/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.service.api.ToC;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.TOC;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class AbstractGetTOCActionHandler
extends AbstractBaseActionHandler {
    protected BaseAttributeBean __bean;
    protected String __docName;
    protected ToC __node = null;

    protected abstract String __getReportDocument();

    protected abstract void __checkDocumentExists() throws Exception;

    public AbstractGetTOCActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    protected void __execute() throws Exception {
        this.prepareParameters();
        this.doExecution();
        this.prepareResponse();
    }

    protected void prepareParameters() throws Exception {
        this.__bean = this.context.getBean();
        this.__docName = this.__getReportDocument();
        this.__checkDocumentExists();
    }

    protected void doExecution() throws ReportServiceException, RemoteException {
        Oprand[] oprands = this.operation.getOprand();
        InputOptions options = new InputOptions();
        HttpServletRequest request = this.context.getRequest();
        options.setOption("request", request);
        BaseAttributeBean bean = (BaseAttributeBean)request.getAttribute("attributeBean");
        if (bean != null) {
            options.setOption("locale", bean.getLocale());
            options.setOption("timeZone", bean.getTimeZone());
        }
        this.__node = oprands != null && oprands.length > 0 ? this.getReportService().getTOC(this.__docName, oprands[0].getValue(), options) : this.getReportService().getTOC(this.__docName, null, options);
    }

    protected void prepareResponse() throws ReportServiceException, RemoteException {
        TOC toc = new TOC();
        List children = this.__node.getChildren();
        if (children != null && children.size() > 0) {
            TOC[] childTOCNodes = new TOC[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                ToC child = (ToC)children.get(i);
                childTOCNodes[i] = new TOC();
                childTOCNodes[i].setId(child.getID());
                childTOCNodes[i].setDisplayName(ParameterAccessor.htmlEncode(child.getDisplayName()));
                childTOCNodes[i].setBookmark(child.getBookmark());
                childTOCNodes[i].setStyle(child.getStyle());
                childTOCNodes[i].setIsLeaf(child.getChildren() == null || child.getChildren().size() <= 0);
            }
            toc.setChild(childTOCNodes);
        }
        Data data = new Data();
        data.setTOC(toc);
        UpdateData updateData = new UpdateData();
        updateData.setTarget("birtToc");
        updateData.setData(data);
        Update update = new Update();
        update.setUpdateData(updateData);
        this.response.setUpdate(new Update[]{update});
    }
}

