/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;

public abstract class AbstractChangeParameterActionHandler
extends AbstractBaseActionHandler {
    public AbstractChangeParameterActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    protected void __execute() throws Exception {
        InputOptions options;
        BaseAttributeBean attrBean = this.context.getBean();
        boolean svgFlag = this.getSVGFlag(this.operation.getOprand());
        this.runReport();
        String bookmark = null;
        boolean useBookmark = false;
        String docName = attrBean.getReportDocumentName();
        long pageNumber = this.getPageNumber(this.context.getRequest(), this.operation.getOprand(), docName);
        if (!this.isValidPageNumber(this.context.getRequest(), pageNumber, docName) && (bookmark = this.getBookmark(this.operation.getOprand(), attrBean)) != null && bookmark.length() > 0) {
            options = new InputOptions();
            options.setOption("request", this.context.getRequest());
            options.setOption("locale", attrBean.getLocale());
            options.setOption("timeZone", attrBean.getTimeZone());
            if (this.isToc(this.operation.getOprand(), attrBean)) {
                bookmark = this.getReportService().findTocByName(docName, bookmark, options);
            }
            pageNumber = this.getReportService().getPageNumberByBookmark(docName, bookmark, options);
            if (!this.isValidPageNumber(this.context.getRequest(), pageNumber, docName)) {
                AxisFault fault = new AxisFault();
                fault.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.INVALID_BOOKMARK", new String[]{this.getBookmark(this.operation.getOprand(), attrBean)}));
                throw fault;
            }
            useBookmark = true;
        }
        options = this.createInputOptions(attrBean, svgFlag);
        this.doRenderPage(options, docName, pageNumber, useBookmark, bookmark);
    }

    protected abstract void runReport() throws Exception;

    protected abstract void doRenderPage(InputOptions var1, String var2, long var3, boolean var5, String var6) throws ReportServiceException, RemoteException;

    protected boolean isValidPageNumber(HttpServletRequest request, long pageNumber, String documentName) throws RemoteException, ReportServiceException {
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        return pageNumber > 0L && pageNumber <= this.getReportService().getPageCount(documentName, options, new OutputOptions());
    }

    protected long getPageNumber(HttpServletRequest request, Oprand[] params, String documentName) throws RemoteException, ReportServiceException {
        long pageNumber = -1L;
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (!"__page".equalsIgnoreCase(params[i].getName())) continue;
                try {
                    pageNumber = Integer.parseInt(params[i].getValue());
                }
                catch (NumberFormatException e) {
                    AxisFault fault = new AxisFault();
                    fault.setFaultCode(new QName("DocumentProcessor.getPageNumber( )"));
                    fault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.PAGE_NUMBER_PARSE_ERROR", new Object[]{params[i].getValue()}));
                    throw fault;
                }
                InputOptions options = new InputOptions();
                options.setOption("request", request);
                long totalPageNumber = this.getReportService().getPageCount(documentName, options, new OutputOptions());
                if (pageNumber > 0L && pageNumber <= totalPageNumber) break;
                AxisFault fault = new AxisFault();
                fault.setFaultCode(new QName("DocumentProcessor.getPageNumber( )"));
                fault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.INVALID_PAGE_NUMBER", new Object[]{pageNumber, totalPageNumber}));
                throw fault;
            }
        }
        return pageNumber;
    }
}

