/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc.document;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.toc.ITOCConstants;
import org.eclipse.birt.report.engine.toc.ITOCReader;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.document.DocTreeNode;

public class TOCReaderV3
implements ITOCReader,
ITOCConstants {
    static final Logger logger = Logger.getLogger(TOCReaderV3.class.getName());
    DocTreeNode root;
    RAInputStream in;
    ClassLoader classloader;

    public TOCReaderV3(RAInputStream in, ClassLoader loader) throws IOException {
        this(in, loader, false);
    }

    public TOCReaderV3(RAInputStream in, ClassLoader loader, boolean checkVersion) throws IOException {
        DataInputStream input;
        String version;
        this.in = in;
        this.classloader = loader;
        if (checkVersion && !"__Version : 3.0".equals(version = IOUtil.readString((DataInputStream)(input = new DataInputStream((InputStream)in))))) {
            throw new IOException("Unsupported version:" + version);
        }
        int offset = (int)in.getOffset();
        this.root = this.readNode(offset);
    }

    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in.close();
            }
        }
    }

    public ITreeNode readTree() throws IOException {
        return this.root;
    }

    private synchronized DocTreeNode readNode(int offset) throws IOException {
        DocTreeNode node = new DocTreeNode();
        node.offset = offset;
        this.in.seek((long)offset);
        node.next = this.in.readInt();
        node.child = this.in.readInt();
        node.childCount = this.in.readInt();
        int byteSize = this.in.readInt();
        byte[] bytes = new byte[byteSize];
        this.in.readFully(bytes, 0, byteSize);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
        node.readNode(input, this.classloader);
        node.children = new NodeCollection(node);
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeCollection
    extends AbstractCollection<ITreeNode> {
        DocTreeNode parent;

        NodeCollection(DocTreeNode parent) {
            this.parent = parent;
        }

        @Override
        public Iterator<ITreeNode> iterator() {
            return new NodeCollectionIterator(this.parent);
        }

        @Override
        public int size() {
            return this.parent.childCount;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class NodeCollectionIterator
        implements Iterator<ITreeNode> {
            DocTreeNode parent;
            int nextIndex;
            int nextOffset;
            boolean fatalError;

            NodeCollectionIterator(DocTreeNode parent) {
                this.parent = parent;
                this.nextIndex = 0;
                this.nextOffset = parent.child;
                this.fatalError = false;
            }

            @Override
            public boolean hasNext() {
                if (!this.fatalError) {
                    return this.nextIndex < this.parent.childCount;
                }
                return false;
            }

            @Override
            public ITreeNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    DocTreeNode nextNode = TOCReaderV3.this.readNode(this.nextOffset);
                    nextNode.parent = this.parent;
                    ++this.nextIndex;
                    this.nextOffset = nextNode.next;
                    return nextNode;
                }
                catch (IOException ex) {
                    logger.log(Level.INFO, "failed to load the toc node at " + this.nextOffset, ex);
                    this.fatalError = true;
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

