/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.ISplitter;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.LineBreakChunk;

public class FontSplitter
implements ISplitter {
    public static final char MISSING_CHAR = '?';
    private FontHandler fh = null;
    private boolean fontSubstitution;
    private int baseLevel = 0;
    private int runLevel = 0;
    private int baseOffset = 0;
    private char[] chunkText = null;
    private int chunkStartPos = 0;
    private int currentPos = -1;
    private FontInfo lastFontInfo = null;
    private Chunk lineBreak = null;
    private boolean replaceUnknownChar = true;

    public FontSplitter(FontMappingManager fontManager, Chunk inputChunk, ITextContent textContent, boolean fontSubstitution, boolean replaceUnknownChar) {
        this.fontSubstitution = fontSubstitution;
        this.chunkText = inputChunk.getText().toCharArray();
        this.baseOffset = inputChunk.getOffset();
        this.baseLevel = inputChunk.getBaseLevel();
        this.runLevel = inputChunk.getRunLevel();
        this.fh = new FontHandler(fontManager, textContent, fontSubstitution);
        this.replaceUnknownChar = replaceUnknownChar;
    }

    public FontSplitter(FontMappingManager fontManager, Chunk inputChunk, ITextContent textContent, boolean fontSubstitution) {
        this.fontSubstitution = fontSubstitution;
        this.chunkText = inputChunk.getText().toCharArray();
        this.baseOffset = inputChunk.getOffset();
        this.baseLevel = inputChunk.getBaseLevel();
        this.runLevel = inputChunk.getRunLevel();
        this.fh = new FontHandler(fontManager, textContent, fontSubstitution);
    }

    /*
     * Unable to fully structure code
     */
    private Chunk buildChunk() {
        if (!this.fontSubstitution) {
            c = new Chunk(new String(this.chunkText), this.baseOffset, this.baseLevel, this.runLevel, this.fh.getFontInfo());
            this.chunkStartPos = this.chunkText.length;
            return c;
        }
        if (this.lineBreak == null) ** GOTO lbl24
        result = this.lineBreak;
        this.lineBreak = null;
        ++this.chunkStartPos;
        return result;
lbl-1000:
        // 1 sources

        {
            lineBreakChunk = this.processLineBreak();
            if (lineBreakChunk != null) {
                return lineBreakChunk;
            }
            fontSelected = this.fh.selectFont(this.chunkText[this.currentPos]);
            if (this.replaceUnknownChar && !fontSelected) {
                this.chunkText[this.currentPos] = 63;
            }
            if (!this.fh.isFontChanged()) continue;
            if (this.lastFontInfo == null) {
                this.lastFontInfo = this.fh.getFontInfo();
                continue;
            }
            c = new Chunk(new String(this.chunkText, this.chunkStartPos, this.currentPos - this.chunkStartPos), this.baseOffset + this.chunkStartPos, this.baseLevel, this.runLevel, this.lastFontInfo);
            this.chunkStartPos = this.currentPos;
            this.lastFontInfo = this.fh.getFontInfo();
            return c;
lbl24:
            // 3 sources

            ** while (++this.currentPos < this.chunkText.length)
        }
lbl25:
        // 1 sources

        if (this.currentPos >= this.chunkText.length - 1) {
            c = new Chunk(new String(this.chunkText, this.chunkStartPos, this.chunkText.length - this.chunkStartPos), this.baseOffset + this.chunkStartPos, this.baseLevel, this.runLevel, this.lastFontInfo);
            this.chunkStartPos = this.currentPos + 1;
            return c;
        }
        return null;
    }

    private Chunk processLineBreak(Chunk lineBreakChunk) {
        int returnCharacterCount = lineBreakChunk.getLength();
        if (this.lastFontInfo == null) {
            this.currentPos = this.currentPos + returnCharacterCount - 1;
            this.chunkStartPos = this.currentPos + 1;
            return lineBreakChunk;
        }
        this.lineBreak = lineBreakChunk;
        Chunk c = new Chunk(new String(this.chunkText, this.chunkStartPos, this.currentPos - this.chunkStartPos), this.baseOffset + this.chunkStartPos, this.baseLevel, this.runLevel, this.lastFontInfo);
        this.chunkStartPos = this.currentPos = this.currentPos + returnCharacterCount - 1;
        return c;
    }

    private Chunk processLineBreak() {
        LineBreakChunk lineBreakChunk = null;
        if (this.chunkText[this.currentPos] == '\n') {
            lineBreakChunk = new LineBreakChunk("\n");
            lineBreakChunk.setOffset(this.currentPos);
        } else if (this.chunkText[this.currentPos] == '\r') {
            lineBreakChunk = new LineBreakChunk("\r");
            lineBreakChunk.setOffset(this.currentPos);
            if (this.currentPos + 1 < this.chunkText.length && this.chunkText[this.currentPos + 1] == '\n') {
                lineBreakChunk.setText("\r\n");
            } else {
                lineBreakChunk.setText("\r");
            }
        }
        if (lineBreakChunk != null) {
            return this.processLineBreak(lineBreakChunk);
        }
        return null;
    }

    public boolean hasMore() {
        return this.chunkText.length > this.chunkStartPos;
    }

    public Chunk getNext() {
        return this.buildChunk();
    }
}

