/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.RegionLayoutEngine;
import org.eclipse.birt.report.engine.nLayout.area.impl.HtmlRegionArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.SizeBasedContent;

public class HTMLLeafItemLM
extends HTMLAbstractLM
implements ILayoutManager {
    public HTMLLeafItemLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 0;
    }

    protected boolean layoutChildren() {
        return false;
    }

    protected boolean isChildrenFinished() {
        return true;
    }

    protected void end(boolean finished) {
    }

    protected void start(boolean isFirst) throws BirtException {
        if (this.content instanceof TextContent || this.content instanceof LabelContent || this.content instanceof DataContent) {
            this.splitText();
        }
        if (this.emitter != null) {
            this.context.getPageBufferManager().startContent(this.content, this.emitter, true);
        }
    }

    private void splitText() {
        Integer taskType = (Integer)this.engine.getOption("task_type");
        if (taskType == 2 && this.context.isFixedLayout()) {
            SizeBasedContent sizeBasedContent = this.context.getPageHintManager().getSizeBasedContentMapping().get(this.content.getInstanceID().toUniqueString());
            if (sizeBasedContent == null || sizeBasedContent.dimension == -1) {
                return;
            }
            HtmlRegionArea container = new HtmlRegionArea();
            container.setWidth(sizeBasedContent.width);
            IReportContent report = this.content.getReportContent();
            IContainerContent containerContent = report.createContainerContent();
            containerContent.getChildren().add(this.content);
            LayoutContext pdfLayoutContext = new LayoutContext();
            pdfLayoutContext.setFormat("pdf");
            pdfLayoutContext.setFixedLayout(true);
            pdfLayoutContext.setInHtmlRender(true);
            pdfLayoutContext.setLocale(this.engine.locale);
            pdfLayoutContext.setHtmlLayoutContext(this.context);
            pdfLayoutContext.setMaxBP(Integer.MAX_VALUE);
            pdfLayoutContext.setReport(report);
            RegionLayoutEngine rle = new RegionLayoutEngine(container, pdfLayoutContext);
            try {
                rle.layout(containerContent);
            }
            catch (BirtException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

