/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.IStyledElement;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.w3c.dom.css.CSSValueList;

public class LayoutUtil {
    public static MasterPageDesign getMasterPage(IReportContent report, String masterPage) {
        MasterPageDesign pageDesign = null;
        if (masterPage != null && !"".equals(masterPage) && (pageDesign = report.getDesign().findMasterPage(masterPage)) != null) {
            return pageDesign;
        }
        return LayoutUtil.getDefaultMasterPage(report);
    }

    public static MasterPageDesign getDefaultMasterPage(IReportContent report) {
        PageSetupDesign pageSetup = report.getDesign().getPageSetup();
        int pageCount = pageSetup.getMasterPageCount();
        if (pageCount > 0) {
            MasterPageDesign pageDesign = pageSetup.getMasterPage(0);
            return pageDesign;
        }
        return null;
    }

    public static boolean isHidden(IStyledElement content, String format, boolean outputDisplayNone, boolean hiddenMask) {
        if (content != null) {
            ICellContent cell;
            IColumn column;
            IStyle style = content.getStyle();
            if (!outputDisplayNone && IStyle.NONE_VALUE == style.getProperty(54)) {
                return true;
            }
            if (content instanceof IColumn ? LayoutUtil.isHiddenByVisibility((IColumn)content, format, hiddenMask) : LayoutUtil.isHiddenByVisibility(style, format, hiddenMask)) {
                return true;
            }
            if (content instanceof ICellContent && (column = (cell = (ICellContent)content).getColumnInstance()) != null) {
                return LayoutUtil.isHiddenByVisibility(column, format, hiddenMask);
            }
        }
        return false;
    }

    private static boolean isHiddenByVisibility(IStyle style, String format, boolean hiddenMask) {
        CSSValueList formats = (CSSValueList)style.getProperty(41);
        return formats != null && (hiddenMask ? LayoutUtil.contains(formats, "all") : LayoutUtil.contains(formats, format));
    }

    public static boolean isHiddenByVisibility(IColumn column, String format, boolean hiddenMask) {
        String columnFormats = column.getVisibleFormat();
        return columnFormats != null && (hiddenMask ? LayoutUtil.contains(columnFormats, "all") : LayoutUtil.contains(columnFormats, "viewer") || LayoutUtil.contains(columnFormats, "all") || LayoutUtil.contains(columnFormats, format));
    }

    private static boolean contains(CSSValueList formats, String format) {
        int length = formats.getLength();
        int i = 0;
        while (i < length) {
            String fmt = formats.item(i).getCssText();
            if ("viewer".equalsIgnoreCase(fmt) || "all".equalsIgnoreCase(fmt) || format.equalsIgnoreCase(fmt)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean contains(String formats, String format) {
        int index = formats.indexOf(format);
        if (index != -1) {
            if (index > 0 && formats.charAt(index - 1) != ',') {
                return false;
            }
            int lastIndex = index + format.length();
            return lastIndex >= formats.length() || formats.charAt(lastIndex) == ',';
        }
        return false;
    }

    public static boolean isRepeatableBand(IBandContent band) {
        IContent parent = (IContent)band.getParent();
        if (parent instanceof IGroupContent) {
            IGroupContent group = (IGroupContent)parent;
            if (band.getBandType() == 3) {
                return group.isHeaderRepeat();
            }
        } else if (parent instanceof ITableContent) {
            ITableContent table = (ITableContent)parent;
            if (band.getBandType() == 1) {
                return table.isHeaderRepeat();
            }
        } else if (parent instanceof IListContent) {
            IListContent list = (IListContent)parent;
            if (band.getBandType() == 1) {
                return list.isHeaderRepeat();
            }
        }
        return false;
    }

    public static boolean isRepeatableRow(IRowContent row) {
        IContent parent = (IContent)row.getParent();
        if (parent != null && parent instanceof IBandContent) {
            IContent pp;
            IBandContent band = (IBandContent)parent;
            int type = band.getBandType();
            if (type == 1) {
                IContent pp2 = (IContent)band.getParent();
                if (pp2 != null && pp2 instanceof ITableContent) {
                    ITableContent table = (ITableContent)band.getParent();
                    return table.isHeaderRepeat();
                }
            } else if (type == 3 && (pp = (IContent)band.getParent()) != null && pp instanceof IGroupContent) {
                IGroupContent group = (IGroupContent)band.getParent();
                return group.isHeaderRepeat();
            }
        }
        return false;
    }
}

