/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsForbiddenException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.OverriddenValuesState;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ReportElementState
extends DesignParseState {
    protected DesignElement container = null;
    protected int slotID = 0;
    protected String containmentPropName = null;

    public ReportElementState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler);
        this.container = theContainer;
        this.slotID = slot;
    }

    public ReportElementState(ModuleParserHandler handler, DesignElement theContainer, String prop) {
        super(handler);
        this.container = theContainer;
        this.containmentPropName = prop;
    }

    public ReportElementState(ModuleParserHandler theHandler) {
        super(theHandler);
    }

    public abstract DesignElement getElement();

    private boolean checkContainer(DesignElement container, int slotID, DesignElement content) {
        ElementDefn containerDefn = (ElementDefn)container.getDefn();
        assert (containerDefn.isContainer());
        if (!StringUtil.isBlank(this.containmentPropName)) {
            PropertyDefn propDefn = (PropertyDefn)((Object)containerDefn.getProperty(this.containmentPropName));
            assert (propDefn != null);
            assert (propDefn.canContain(content) || container instanceof ExtendedItem);
            if (container.getExtendsElement() != null) {
                this.handler.getErrorHandler().semanticWarning((Exception)((Object)new ContentException(container, this.containmentPropName, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN")));
                return false;
            }
            if (!propDefn.isList() && new ContainerContext(container, this.containmentPropName).getContentCount(this.handler.module) > 0) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new ContentException(container, this.containmentPropName, "Error.ContentException.SLOT_IS_FULL")));
                return false;
            }
            return true;
        }
        SlotDefn slotInfo = (SlotDefn)containerDefn.getSlot(slotID);
        assert (slotInfo != null);
        assert (slotInfo.canContain(content));
        if (container.getExtendsElement() != null) {
            this.handler.getErrorHandler().semanticWarning((Exception)((Object)new ContentException(container, slotID, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN")));
            return false;
        }
        if (!slotInfo.isMultipleCardinality() && container.getSlot(slotID).getCount() > 0) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new ContentException(container, slotID, "Error.ContentException.SLOT_IS_FULL")));
            return false;
        }
        return true;
    }

    protected boolean addToSlot(DesignElement container, int slotID, DesignElement content) {
        if (!this.checkContainer(container, slotID, content)) {
            return false;
        }
        if (container instanceof ExtendedItem && !StringUtil.isBlank(this.containmentPropName)) {
            PropertyDefn propDefn = (PropertyDefn)((Object)container.getDefn().getProperty(this.containmentPropName));
            assert (propDefn != null);
            if (!propDefn.canContain(content)) {
                ((ExtendedItem)container).getExtensibilityProvider().handleIllegalChildren(this.containmentPropName, content);
                return true;
            }
        }
        Module module = this.handler.getModule();
        long elementID = content.getID();
        if (elementID > 0L) {
            DesignElement element = module.getElementByID(elementID);
            assert (element != content);
            if (element == null) {
                module.addElementID(content);
            } else {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{content.getIdentifier(), element.getIdentifier()}, "Error.DesignParserException.DUPLICATE_ELEMENT_ID")));
                return false;
            }
        }
        if (!StringUtil.isBlank(this.containmentPropName)) {
            container.add(this.handler.module, content, this.containmentPropName);
        } else {
            container.add(content, slotID);
        }
        this.addToNamespace(content);
        return true;
    }

    protected void initElement(Attributes attrs, boolean nameRequired) {
        DesignElement element = this.getElement();
        String name = attrs.getValue("name");
        ElementPropertyDefn propDefn = element.getPropertyDefn("name");
        if (!StringUtil.isBlank(name) && propDefn == null) {
            this.handler.getErrorHandler().semanticWarning((Exception)((Object)new NameException(element, name, "Error.NameException.NAME_FORBIDDEN")));
        } else if (propDefn != null) {
            boolean isValidName = true;
            try {
                name = (String)propDefn.validateValue(this.handler.getModule(), name);
            }
            catch (PropertyValueException propertyValueException) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new NameException(element, name, "Error.NameException.INVALID_NAME")));
                isValidName = false;
                element.setName(name);
            }
            if (isValidName) {
                if (StringUtil.isBlank(name)) {
                    if (nameRequired && this.handler.versionNumber <= 3021200 && element instanceof ExtendedItem) {
                        this.handler.addUnnamedReportItem(element);
                    }
                } else {
                    element.setName(name);
                }
            }
        }
        String extendsName = attrs.getValue("extends");
        if (!StringUtil.isBlank(extendsName) && element.getDefn().canExtend()) {
            element.setExtendsName(extendsName);
            this.resolveExtendsElement();
        } else if (!StringUtil.isBlank(attrs.getValue("extends"))) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.ILLEGAL_EXTENDS")));
        }
        this.initSimpleElement(attrs);
    }

    protected final void initSimpleElement(Attributes attrs) {
        String viewAction;
        DesignElement element = this.getElement();
        if (this.handler.markLineNumber) {
            this.handler.tempLineNumbers.put(element, new Integer(this.handler.getCurrentLineNo()));
        }
        if (!(element instanceof ContentElement)) {
            try {
                String theID = attrs.getValue("id");
                if (!StringUtil.isBlank(theID)) {
                    long id = Long.parseLong(theID);
                    if (id <= 0L) {
                        this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{element.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
                    }
                    element.setID(id);
                } else {
                    this.handler.unhandleIDElements.add(element);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{element.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
            }
        }
        if (!StringUtil.isBlank(viewAction = attrs.getValue("viewAction"))) {
            this.setProperty("viewAction", viewAction);
        }
        this.addToSlot(this.container, this.slotID, element);
    }

    private void resolveExtendsElement() {
        DesignElement element = this.getElement();
        Module module = this.handler.getModule();
        ElementDefn defn = (ElementDefn)element.getDefn();
        String extendsName = element.getExtendsName();
        if (StringUtil.isBlank(extendsName)) {
            return;
        }
        DesignElement parent = module.resolveElement(extendsName, (PropertyDefn)element.getPropertyDefn("extends"), (IElementDefn)defn);
        if (parent == null) {
            this.handler.getErrorHandler().semanticWarning((Exception)((Object)new InvalidParentException(element, extendsName, "Error.InvalidParentException.PARENT_NOT_FOUND")));
            return;
        }
        try {
            element.checkExtends(parent);
        }
        catch (ExtendsException ex) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
            return;
        }
        element.setExtendsElement(parent);
        ElementStructureUtil.duplicateStructure(parent, element, module);
    }

    private void addToNamespace(DesignElement content) {
        String name = content.getName();
        ElementDefn contentDefn = (ElementDefn)content.getDefn();
        boolean isManagedByNameSpace = this.slotID > -1 ? new ContainerContext(this.container, this.slotID).isManagedByNameSpace() : true;
        Module module = this.handler.getModule();
        if (name == null && contentDefn.getNameOption() == 2 && isManagedByNameSpace) {
            if (content instanceof ExtendedItem && this.handler.versionNumber < 3020800) {
                return;
            }
            this.handler.getErrorHandler().semanticError((Exception)((Object)new NameException(content, name, "Error.NameException.NAME_REQUIRED")));
            return;
        }
        int id = contentDefn.getNameSpaceID();
        if (name != null && id != -1 && isManagedByNameSpace) {
            NameSpace ns = new NameExecutor(content).getNameSpace(module);
            if (ns.contains(name)) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new NameException(content, name, "Error.NameException.DUPLICATE")));
                return;
            }
            DesignElement parent = content.getExtendsElement();
            if (id == 1 && parent != null && parent.getContainerInfo().getSlotID() != 5) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new ExtendsForbiddenException(content, content.getElementName(), "Error.ExtendsForbiddenException.PARENT_NOT_IN_COMPONENT")));
                return;
            }
            ns.insert(content);
        }
    }

    private void addTheVirualElements2Map(DesignElement element) {
        ContentIterator contentIter = new ContentIterator(this.handler.module, element);
        Module module = this.handler.getModule();
        while (contentIter.hasNext()) {
            DesignElement virtualElement = (DesignElement)contentIter.next();
            if (virtualElement.getName() == null) continue;
            module.makeUniqueName(virtualElement);
            this.addToNamespace(virtualElement);
        }
    }

    protected void parseExtensionName(Attributes attrs, boolean extensionNameRequired) {
        DesignElement element = this.getElement();
        assert (element instanceof IExtendableElement);
        String extensionName = this.getAttrib(attrs, "extensionName");
        if (StringUtil.isBlank(extensionName)) {
            if (!extensionNameRequired) {
                return;
            }
            SemanticError e = new SemanticError(element, "Error.SemanticError.MISSING_EXTENSION");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
        } else {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getElement(extensionName);
            if (extDefn == null) {
                SemanticError e = new SemanticError(element, new String[]{extensionName}, "Error.SemanticError.EXTENSION_NOT_FOUND");
                RecoverableError.dealMissingInvalidExtension(this.handler, e);
            }
        }
        this.setProperty("extensionName", extensionName);
    }

    protected void makeTestExpressionCompatible() {
        List mapRules;
        int i;
        List highlightRules;
        DesignElement element = this.getElement();
        if (this.handler.tempValue.get("highlightRules") != null && (highlightRules = element.getListProperty(this.handler.getModule(), "highlightRules")) != null) {
            i = 0;
            while (i < highlightRules.size()) {
                HighlightRule highlightRule = (HighlightRule)highlightRules.get(i);
                highlightRule.setTestExpression((String)this.handler.tempValue.get("highlightRules"));
                ++i;
            }
            this.handler.tempValue.remove("highlightRules");
        }
        if (this.handler.tempValue.get("mapRules") != null && (mapRules = element.getListProperty(this.handler.getModule(), "mapRules")) != null) {
            i = 0;
            while (i < mapRules.size()) {
                MapRule mapRule = (MapRule)mapRules.get(i);
                mapRule.setTestExpression((String)this.handler.tempValue.get("mapRules"));
                ++i;
            }
            this.handler.tempValue.remove("mapRules");
        }
    }

    public AbstractParseState startElement(String tagName) {
        ElementDefn defn = (ElementDefn)this.getElement().getDefn();
        if ("overridden-values".equalsIgnoreCase(tagName) && (defn.getSlotCount() > 0 || defn.getContents().size() > 0) && defn.canExtend()) {
            return new OverriddenValuesState((ModuleParserHandler)this.getHandler(), this.getElement());
        }
        return super.startElement(tagName);
    }

    public void end() throws SAXException {
        super.end();
        if (this.getElement().getExtendsElement() != null && this.getElement().getDefn().isContainer()) {
            this.addTheVirualElements2Map(this.getElement());
            if (!this.handler.unhandleIDElements.contains(this.getElement())) {
                this.handler.unhandleIDElements.add(this.getElement());
            }
        }
        this.getElement().getHandle(this.handler.module);
    }
}

