/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.net.URL;
import java.util.Map;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatibleListPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleStructureState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.LibraryUtil;
import org.xml.sax.SAXException;

public class IncludedLibrariesStructureListState
extends CompatibleListPropertyState {
    IncludedLibrariesStructureListState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.STRUCTURE_TAG == tagValue) {
            return new IncludedLibraryStructureState(this.handler, this.element, this.propDefn);
        }
        return super.startElement(tagName);
    }

    private class IncludedLibraryStructureState
    extends CompatibleStructureState {
        IncludedLibraryStructureState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn) {
            super(theHandler, element, propDefn);
            this.lineNumber = this.handler.getCurrentLineNo();
        }

        public void end() throws SAXException {
            super.end();
            IncludedLibrary includeLibrary = (IncludedLibrary)this.struct;
            if (this.handler.markLineNumber) {
                this.handler.module.addLineNo(this.struct, new Integer(this.lineNumber));
            }
            if (StringUtil.isBlank(includeLibrary.getNamespace())) {
                String fileName = StringUtil.extractFileName(includeLibrary.getFileName());
                includeLibrary.setNamespace(fileName);
            }
            URL url = this.handler.module.findResource(includeLibrary.getFileName(), 2);
            String namespace = includeLibrary.getNamespace();
            Module outermostModule = this.handler.module.findOutermostModule();
            Library foundLib = null;
            try {
                foundLib = LibraryUtil.checkIncludeLibrary(this.handler.module, namespace, url, outermostModule);
            }
            catch (LibraryException ex) {
                if ("Error.LibraryException.LIBRARY_ALREADY_INCLUDED".equalsIgnoreCase(ex.getErrorCode())) {
                    this.handler.getErrorHandler().semanticWarning((Exception)((Object)ex));
                } else {
                    this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
                }
                return;
            }
            Map<String, Library> reloadLibs = this.handler.reloadLibs;
            foundLib = reloadLibs.get(namespace);
            this.handler.module.loadLibrarySilently(includeLibrary, foundLib, reloadLibs);
        }
    }
}

