/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.scripts.IScriptableObjectClassInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ExtensionValidator;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.OverridePropertyInfo;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;

public final class PeerExtensionElementDefn
extends ExtensionElementDefn {
    protected IReportItemFactory reportItemFactory = null;
    protected Map overridePropertyInfoMap = new HashMap();
    private IScriptableObjectClassInfo scriptableFactory = null;

    public PeerExtensionElementDefn(String name, IReportItemFactory reportItemFactory) {
        assert (name != null);
        assert (reportItemFactory != null);
        this.name = name;
        this.reportItemFactory = reportItemFactory;
    }

    public IReportItemFactory getReportItemFactory() {
        return this.reportItemFactory;
    }

    public String getDisplayName() {
        String displayName;
        IMessages messages;
        if (this.displayNameKey != null && this.reportItemFactory != null && (messages = this.reportItemFactory.getMessages()) != null && !StringUtil.isBlank(displayName = messages.getMessage(this.displayNameKey, ThreadResources.getLocale()))) {
            return displayName;
        }
        return this.getName();
    }

    protected void buildProperties() throws MetaDataException {
        super.buildProperties();
        if ("org.eclipse.birt.report.model.reportItemModel".equalsIgnoreCase(this.extensionPoint)) {
            ElementDefn extendedItem = (ElementDefn)MetaDataDictionary.getInstance().getElement("ExtendedItem");
            PropertyDefn extensionName = (PropertyDefn)((Object)extendedItem.getProperty("extensionName"));
            if (this.getProperty("extensionName") == null) {
                this.properties.put("extensionName", extensionName);
                this.cachedProperties.put("extensionName", extensionName);
                this.addPropertyVisibility("extensionName", "hide");
            }
            PropertyDefn extensionVersion = (PropertyDefn)((Object)extendedItem.getProperty("extensionVersion"));
            if (this.getProperty("extensionVersion") == null) {
                this.properties.put("extensionVersion", extensionVersion);
                this.cachedProperties.put("extensionVersion", extensionVersion);
                this.addPropertyVisibility("extensionVersion", "hide");
            }
        }
        this.overrideProperty();
    }

    private void overrideProperty() {
        ElementDefn tmpDefn = this.parent;
        while (tmpDefn != null && tmpDefn instanceof PeerExtensionElementDefn) {
            PeerExtensionElementDefn tmpPeerDefn = (PeerExtensionElementDefn)tmpDefn;
            if (tmpPeerDefn.overridePropertyInfoMap == null || tmpPeerDefn.overridePropertyInfoMap.isEmpty()) {
                tmpDefn = tmpDefn.parent;
                continue;
            }
            for (String propName : tmpPeerDefn.overridePropertyInfoMap.keySet()) {
                this.cachedProperties.put(propName, tmpDefn.cachedProperties.get(propName));
            }
            tmpDefn = tmpDefn.parent;
        }
        Set set = this.overridePropertyInfoMap.keySet();
        for (String propName : set) {
            ElementPropertyDefn clonedDefn;
            OverridePropertyInfo propInfo;
            if (this.properties.get(propName) != null) {
                ElementPropertyDefn defn = (ElementPropertyDefn)this.properties.get(propName);
                if (defn.definedBy == this) continue;
            }
            if ((propInfo = (OverridePropertyInfo)this.overridePropertyInfoMap.get(propName)) == null) continue;
            String units = propInfo.getAllowedUnits();
            String choices = propInfo.getAllowedChoices();
            boolean useOwnSearch = propInfo.useOwnSearch();
            ChoiceSet unitSet = this.buildChoiceSet(MetaDataDictionary.getInstance().getChoiceSet("units"), units);
            ElementPropertyDefn defn = (ElementPropertyDefn)this.cachedProperties.get(propName);
            if (defn == null) continue;
            ChoiceSet choiceSet = null;
            if (choices != null) {
                IChoiceSet tmpSet = defn.getChoices();
                choiceSet = tmpSet != null ? this.buildChoiceSet(tmpSet, choices) : null;
            }
            if (unitSet == null && choiceSet == null && !useOwnSearch || (clonedDefn = (ElementPropertyDefn)this.reflectClass(defn)) == null) continue;
            if (choiceSet != null) {
                clonedDefn.allowedChoices = choiceSet;
            }
            if (unitSet != null) {
                clonedDefn.allowedUnits = unitSet;
            }
            clonedDefn.useOwnSearch = useOwnSearch;
            this.cachedProperties.put(propName, clonedDefn);
        }
    }

    private ChoiceSet buildChoiceSet(IChoiceSet romSet, String units) {
        ArrayList<IChoice> choiceList = new ArrayList<IChoice>();
        if (units != null && units.length() > 0) {
            String[] eachUnit = units.split(",");
            int i = 0;
            while (eachUnit != null && i < eachUnit.length) {
                IChoice romChoice;
                String unit = eachUnit[i];
                if (unit != null && unit.length() > 0 && (romChoice = romSet.findChoice(unit)) != null) {
                    choiceList.add(romChoice);
                }
                ++i;
            }
        }
        if (choiceList.size() == 0) {
            return null;
        }
        ChoiceSet choiceSet = new ChoiceSet();
        IChoice[] choices = new Choice[choiceList.size()];
        choiceList.toArray(choices);
        choiceSet.setChoices(choices);
        return choiceSet;
    }

    private PropertyDefn reflectClass(PropertyDefn defn) {
        ElementPropertyDefn retDefn = null;
        String className = defn.getClass().getName();
        try {
            Class<?> clazz = Class.forName(className);
            retDefn = (ElementPropertyDefn)clazz.newInstance();
            Class<?> ownerClass = defn.getClass();
            Class<?> clonedClass = retDefn.getClass();
            this.shadowCopyProperties(defn, retDefn, ownerClass, clonedClass);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (retDefn == null) {
            return null;
        }
        this.shadowCopyProperties(defn, retDefn, defn.getClass(), ExtensionPropertyDefn.class);
        return retDefn;
    }

    private void shadowCopyProperties(PropertyDefn defn, PropertyDefn clonedDefn, Class ownerClass, Class clonedClass) {
        if (ownerClass == null || clonedClass == null) {
            return;
        }
        Field[] fields = ownerClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            try {
                Object property = field.get(defn);
                Field clonedField = ownerClass.getDeclaredField(field.getName());
                clonedField.set(clonedDefn, property);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            ++i;
        }
        this.shadowCopyProperties(defn, clonedDefn, ownerClass.getSuperclass(), clonedClass.getSuperclass());
    }

    protected void setOverridePropertyInfo(String prop, OverridePropertyInfo propInfo) {
        this.overridePropertyInfoMap.put(prop, propInfo);
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public IScriptableObjectClassInfo getScriptableFactory() {
        return this.scriptableFactory;
    }

    void setScriptableFactory(IScriptableObjectClassInfo scriptableFactory) {
        this.scriptableFactory = scriptableFactory;
    }

    protected void buildTriggerDefnSet() {
        String tmpTriggerDefnName;
        SemanticTriggerDefnSet tmpTriggerSet;
        super.buildTriggerDefnSet();
        if (!StringUtil.isBlank(this.name) && !(tmpTriggerSet = this.getTriggerDefnSet()).contain(tmpTriggerDefnName = "ExtensionValidator")) {
            SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn(tmpTriggerDefnName);
            triggerDefn.setPropertyName(this.getName());
            triggerDefn.setValidator(ExtensionValidator.getInstance());
            tmpTriggerSet.add(triggerDefn);
        }
    }
}

