/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.util.SecurityUtil;

class FileMetaLogger
implements IMetaLogger {
    protected static final String DEFAULT_LOG_FILE = "meta.log";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static Logger logger = Logger.getLogger(FileMetaLogger.class.getName());
    protected Writer writer = null;
    private String fileName = null;
    protected static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public FileMetaLogger() {
        this(DEFAULT_LOG_FILE);
    }

    public FileMetaLogger(String fileName) {
        this.fileName = fileName;
    }

    public void log(String message) {
        if (this.canLog()) {
            try {
                Date dateTime = Calendar.getInstance().getTime();
                StringBuffer sb = new StringBuffer();
                sb.append(df.format(dateTime));
                sb.append(" Message [");
                sb.append(String.valueOf(message.toString()) + "]" + "\n");
                this.writer.write(sb.toString());
                this.writer.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void log(String message, Throwable t) {
        if (this.canLog()) {
            try {
                Date dateTime = Calendar.getInstance().getTime();
                StringBuffer sb = new StringBuffer();
                sb.append(df.format(dateTime));
                sb.append("  Message [");
                sb.append(String.valueOf(message.toString()) + "]" + "\n");
                sb.append("\t\t\t\t\t");
                sb.append(" Exception [");
                sb.append(this.getExceptionString(t));
                sb.append("]\n");
                this.writer.write(sb.toString());
                this.writer.flush();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Loose catch block
     */
    protected String getExceptionString(Throwable aException) {
        ByteArrayOutputStream outStream = null;
        PrintStream printStream = null;
        outStream = new ByteArrayOutputStream();
        printStream = new PrintStream(outStream);
        aException.printStackTrace(printStream);
        String stackTrace = outStream.toString();
        printStream.close();
        printStream = null;
        outStream.close();
        outStream = null;
        String string = stackTrace;
        try {
            if (printStream != null) {
                printStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (printStream != null) {
                        printStream.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (printStream != null) {
                    printStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    protected OutputStreamWriter createWriter(String fileName) throws IOException {
        OutputStreamWriter retWriter;
        block2: {
            retWriter = null;
            try {
                retWriter = new OutputStreamWriter((OutputStream)SecurityUtil.createFileOutputStream(new File(fileName)), DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return retWriter;
    }

    protected boolean canLog() {
        if (this.fileName != null && this.writer == null) {
            try {
                this.writer = this.createWriter(this.fileName);
            }
            catch (IOException iOException) {
                this.fileName = null;
                return false;
            }
        }
        return true;
    }

    public void close() {
        if (this.writer != null) {
            try {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {
                    this.writer = null;
                }
            }
            finally {
                this.writer = null;
            }
        }
    }
}

