/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.extension.ExtensibilityProvider;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public abstract class ModelExtensibilityProvider
extends ExtensibilityProvider {
    String extensionName = null;

    public ModelExtensibilityProvider(DesignElement element, String extensionName) {
        super(element);
        this.extensionName = extensionName;
    }

    public final ExtensionElementDefn getExtDefn() {
        if (this.extensionName == null) {
            return null;
        }
        if (this.cachedExtDefn == null) {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            this.cachedExtDefn = (ExtensionElementDefn)dd.getElement(this.extensionName);
        }
        return this.cachedExtDefn;
    }

    public void checkExtends(DesignElement parent) throws ExtendsException {
        String parentExt = (String)parent.getProperty(null, "extensionName");
        assert (this.extensionName != null);
        if (!this.extensionName.equalsIgnoreCase(parentExt)) {
            throw new WrongTypeException(this.element, parent, "Error.WrongTypeException.WRONG_EXTENSION_TYPE");
        }
    }
}

