/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.olap;

import java.util.List;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.ICubeModel;
import org.eclipse.birt.report.model.elements.olap.MeasureGroup;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public abstract class Cube
extends ReferenceableElement
implements ICubeModel {
    public Cube() {
    }

    public Cube(String name) {
        super(name);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitCube(this);
    }

    public String getElementName() {
        return "Cube";
    }

    public DesignElement getDefaultMeasureGroup(Module module) {
        DesignElement measureGroup = this.getReferenceProperty(module, "defaultMeasureGroup");
        if (measureGroup != null) {
            if (measureGroup.getContainer() != this) {
                return null;
            }
            return measureGroup;
        }
        List groups = this.getListProperty(module, "measureGroups");
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        return (DesignElement)groups.get(0);
    }

    public void setDefaultMeasureGroup(MeasureGroup defaultMeasureGroup) {
        this.setProperty("defaultMeasureGroup", (Object)new ElementRefValue(null, defaultMeasureGroup));
    }

    public void setDefaultMeasureGroup(int index) {
        List groups = this.getListProperty(this.getRoot(), "measureGroups");
        if (groups == null || groups.isEmpty()) {
            return;
        }
        if (index >= 0 && index < groups.size()) {
            this.setProperty("defaultMeasureGroup", (Object)new ElementRefValue(null, (DesignElement)groups.get(index)));
        }
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        DesignElement element = (DesignElement)super.doClone(policy);
        Module module = this.getRoot();
        DesignElement measureGroup = this.getDefaultMeasureGroup(module);
        if (measureGroup != null) {
            int index = measureGroup.getIndex(module);
            DesignElement clonedMeasureGroup = new ContainerContext(element, "measureGroups").getContent(module, index);
            assert (clonedMeasureGroup != null);
            element.setProperty("defaultMeasureGroup", (Object)new ElementRefValue(null, clonedMeasureGroup));
        }
        return element;
    }
}

