/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.ILibraryModel;
import org.eclipse.birt.report.model.elements.strategy.DummyCopyPolicy;
import org.eclipse.birt.report.model.writer.LibraryWriter;
import org.eclipse.birt.report.model.writer.ModuleWriter;

public class Library
extends Module
implements ILibraryModel {
    private String namespace;
    protected Module host = null;

    public Library(DesignSession theSession, Module host) {
        super(theSession);
        this.host = host;
        this.initSlots();
        this.onCreate();
    }

    public Library(DesignSession theSession) {
        this(theSession, null);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitLibrary(this);
    }

    public String getElementName() {
        return "Library";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle();
    }

    public LibraryHandle handle() {
        if (this.handle == null) {
            this.handle = new LibraryHandle(this);
        }
        return (LibraryHandle)this.handle;
    }

    protected int getSlotCount() {
        return 7;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ModuleWriter getWriter() {
        return new LibraryWriter(this);
    }

    public Module getHost() {
        return this.host;
    }

    public void setHost(Module theHost) {
        this.host = theHost;
    }

    public boolean isRecursiveNamespace(String namespace) {
        Module module = this;
        while (module instanceof Library) {
            Library library = module;
            if (namespace.equals(library.getNamespace())) {
                return true;
            }
            module = library.getHost();
        }
        return false;
    }

    public boolean isRecursiveFile(String fileName) {
        Module module = this;
        while (module instanceof Library) {
            Library library = module;
            if (fileName.equals(library.getLocation())) {
                return true;
            }
            module = library.getHost();
        }
        return false;
    }

    public Theme findNativeTheme(String name) {
        return (Theme)this.nameHelper.getNameSpace(6).getElement(name);
    }

    protected String getNameForDisplayLabel() {
        return this.namespace;
    }

    public ModuleOption getOptions() {
        if (this.options != null) {
            return this.options;
        }
        Module hostModule = this.host;
        if (hostModule != null) {
            ModuleOption hostOptions = hostModule.getOptions();
            if (hostOptions != null) {
                return hostOptions;
            }
            if (hostModule instanceof Library) {
                hostModule = ((Library)hostModule).host;
            }
            return null;
        }
        return null;
    }

    public Module findOutermostModule() {
        Module tmpModule = this;
        while (tmpModule instanceof Library) {
            Module tmpHost = tmpModule.getHost();
            if (tmpHost == null) break;
            tmpModule = tmpHost;
        }
        return tmpModule;
    }

    public Library contextClone(Module newHost) {
        Library cloned = null;
        try {
            cloned = (Library)this.doClone(DummyCopyPolicy.getInstance());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
        cloned.setFileName(this.getFileName());
        cloned.setSystemId(this.getSystemId());
        cloned.setNamespace(this.getNamespace());
        cloned.setHost(newHost);
        return cloned;
    }

    public boolean isCached() {
        if (this.host == null) {
            return super.isCached();
        }
        Module module = this;
        while (module != null) {
            if (module instanceof Library) {
                Library lib = module;
                if (lib.getHost() == null) {
                    return lib.isCached();
                }
                module = lib.getHost();
                continue;
            }
            return ((Module)module).isCached();
        }
        return false;
    }
}

