/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;

public class CssNameManager {
    public static List getStyles(ICssStyleSheetOperation operation) {
        HashMap<String, CssStyle> stylesMap = new HashMap<String, CssStyle>();
        ArrayList<CssStyle> styles = new ArrayList<CssStyle>();
        List csses = operation.getCsses();
        int i = csses.size() - 1;
        while (i >= 0) {
            CssStyleSheet sheet = (CssStyleSheet)csses.get(i);
            List tmpstyles = sheet.getStyles();
            int j = 0;
            while (j < tmpstyles.size()) {
                CssStyle tmpStyle = (CssStyle)tmpstyles.get(j);
                if (stylesMap.get(tmpStyle.getName()) == null) {
                    stylesMap.put(tmpStyle.getName(), tmpStyle);
                    styles.add(tmpStyle);
                }
                ++j;
            }
            --i;
        }
        return styles;
    }

    public static StyleElement getStyle(ICssStyleSheetOperation operation, String styleName) {
        assert (styleName != null);
        List csses = operation.getCsses();
        int i = csses.size() - 1;
        while (i >= 0) {
            CssStyleSheet sheet = (CssStyleSheet)csses.get(i);
            List tmpstyles = sheet.getStyles();
            int j = 0;
            while (j < tmpstyles.size()) {
                CssStyle tmpStyle = (CssStyle)tmpstyles.get(j);
                if (styleName.equalsIgnoreCase(tmpStyle.getName())) {
                    return tmpStyle;
                }
                ++j;
            }
            --i;
        }
        return null;
    }

    public static void adjustStylesForRemove(CssStyleSheet css) {
        List styles = css.getStyles();
        for (CssStyle style : styles) {
            style.updateClientReferences();
        }
    }

    public static void adjustStylesForAdd(Module module, ICssStyleSheetOperation cssOperation, CssStyleSheet sheet, int position) {
        List csses = cssOperation.getCsses();
        int i = 0;
        while (i < position) {
            CssStyleSheet tmpSheet = (CssStyleSheet)csses.get(i);
            List tmpStyles = tmpSheet.getStyles();
            int j = 0;
            while (j < tmpStyles.size()) {
                CssStyle cssStyle = (CssStyle)tmpStyles.get(j);
                if (sheet.findStyle(cssStyle.getName()) != null) {
                    cssStyle.updateClientReferences();
                }
                ++j;
            }
            ++i;
        }
        if (cssOperation instanceof ReportDesign) {
            Theme theme = module.getTheme();
            if (theme == null) {
                return;
            }
            cssOperation = theme;
            csses = cssOperation.getCsses();
            int i2 = 0;
            while (i2 < csses.size()) {
                CssStyleSheet tmpSheet = (CssStyleSheet)csses.get(i2);
                List tmpStyles = tmpSheet.getStyles();
                int j = 0;
                while (j < tmpStyles.size()) {
                    CssStyle cssStyle = (CssStyle)tmpStyles.get(j);
                    if (sheet.findStyle(cssStyle.getName()) != null) {
                        cssStyle.updateClientReferences();
                    }
                    ++j;
                }
                ++i2;
            }
        }
    }
}

