/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.TemplateException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.AbstractContentCommand;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ContentRecord;
import org.eclipse.birt.report.model.command.ElementBackRefRecord;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.NameCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.TemplateCommand;
import org.eclipse.birt.report.model.command.TemplateTransformRecord;
import org.eclipse.birt.report.model.command.UserPropertyCommand;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.IContainerDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.LevelContentIterator;

public class ContentCommand
extends AbstractContentCommand {
    protected boolean unresolveReference;
    protected boolean flag;

    public ContentCommand(Module module, ContainerContext containerInfo) {
        super(module, containerInfo);
    }

    ContentCommand(Module module, ContainerContext containerInfo, boolean flag) {
        super(module, containerInfo);
        this.flag = flag;
    }

    public ContentCommand(Module module, ContainerContext containerInfo, boolean flag, boolean unresolveReference) {
        super(module, containerInfo);
        this.flag = flag;
        this.unresolveReference = unresolveReference;
    }

    protected void checkBeforeAdd(DesignElement content) throws ContentException, NameException {
        assert (content.getContainer() == null);
        super.checkBeforeAdd(content);
        if (this.element.isVirtualElement() || this.element.getExtendsName() != null) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (this.focus.getSlotID() == 5 && StringUtil.isBlank(content.getName())) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.CONTENT_NAME_REQUIRED");
        }
        if (!this.flag) {
            this.checkContainmentContext(content);
        }
    }

    protected void doAdd(int newPos, DesignElement content) throws ContentException, NameException {
        ContentRecord addRecord = newPos == -1 ? new ContentRecord(this.module, this.focus, content, true) : new ContentRecord(this.module, this.focus, content, newPos);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(addRecord.getLabel());
        try {
            TemplateCommand cmd = new TemplateCommand(this.module, this.focus);
            cmd.checkAdd(content);
            super.doAdd(newPos, content);
            this.addElementNames(content);
        }
        catch (NameException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void checkContainmentContext(DesignElement content) throws NameException, ContentException {
        List errors = this.focus.checkContainmentContext(this.module, content);
        if (!errors.isEmpty()) {
            SemanticException e = (SemanticException)((Object)errors.get(0));
            assert (e instanceof NameException || e instanceof ContentException);
            if (e instanceof NameException) {
                throw (NameException)e;
            }
            if (e instanceof ContentException) {
                throw (ContentException)e;
            }
        }
    }

    private void addElementNames(DesignElement content) throws NameException {
        assert (content.getContainer() != null);
        NameCommand nameCmd = new NameCommand(this.module, content);
        nameCmd.addElement();
        ElementDefn defn = (ElementDefn)content.getDefn();
        if (defn.isContainer()) {
            LevelContentIterator iter = new LevelContentIterator(this.module, content, 1);
            while (iter.hasNext()) {
                DesignElement tmpElement = (DesignElement)iter.next();
                this.addElementNames(tmpElement);
            }
        }
    }

    protected void checkBeforeRemove(DesignElement content) throws SemanticException {
        assert (content != null);
        super.checkBeforeRemove(content);
        if (!this.flag && !content.canDrop(this.module)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (this.hasDescendents(content)) {
            throw ContentExceptionFactory.createContentException(new ContainerContext(content, this.focus.getSlotID()), "Error.ContentException.HAS_DESCENDENTS");
        }
    }

    private void adjustDerived(DesignElement obj) throws ExtendsException {
        List derived = obj.getDerived();
        if (derived.isEmpty()) {
            return;
        }
        DesignElement parent = obj.getExtendsElement();
        for (DesignElement child : derived) {
            ExtendsCommand childCmd = new ExtendsCommand(this.module, child);
            childCmd.setExtendsElement(parent);
        }
    }

    private void adjustReferenceClients(IReferencableElement referred) throws SemanticException {
        ArrayList clients = new ArrayList(referred.getClientList());
        for (BackRef ref : clients) {
            DesignElement client = ref.getElement();
            if (this.unresolveReference) {
                ElementBackRefRecord record = new ElementBackRefRecord(this.module, referred, client, ref.getPropertyName());
                this.getActivityStack().execute(record);
                continue;
            }
            if (((DesignElement)((Object)referred)).isStyle()) {
                StyleCommand clientCmd = new StyleCommand(this.module, client);
                clientCmd.setStyleElement((DesignElement)null);
                continue;
            }
            Structure struct = ref.getStructure();
            if (struct != null) {
                MemberRef memberRef = struct.getListMemberRef();
                ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, client);
                cmd.removeItem(memberRef, struct);
                continue;
            }
            if (ref.getPropertyName() == null) continue;
            String propName = ref.getPropertyName();
            ElementPropertyDefn propDefn = client.getPropertyDefn(propName);
            if (propDefn.getTypeCode() == 20 && propDefn.getSubTypeCode() == 15) {
                this.clearMatchedElementRefInList(client, propDefn, referred);
                continue;
            }
            PropertyCommand cmd = new PropertyCommand(this.module, client);
            cmd.setProperty(ref.getPropertyName(), null);
        }
    }

    private void clearMatchedElementRefInList(DesignElement client, ElementPropertyDefn propDefn, IReferencableElement referred) throws SemanticException {
        assert (propDefn.getTypeCode() == 20 && propDefn.getSubTypeCode() == 15);
        List values = (List)client.getProperty(this.module, propDefn);
        if (values == null || values.isEmpty()) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < values.size()) {
            ElementRefValue refValue = (ElementRefValue)values.get(i);
            if (refValue.getElement() == referred) {
                index = i;
                break;
            }
            ++i;
        }
        assert (index != -1);
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, client);
        cmd.removeItem((MemberRef)new CachedMemberRef(propDefn), index);
    }

    private void adjustReferredClients(DesignElement element) {
        List propDefns = element.getPropertyDefns();
        for (PropertyDefn propDefn : propDefns) {
            List valueList;
            if ("extends".equalsIgnoreCase(propDefn.getName()) || "style".equalsIgnoreCase(propDefn.getName())) continue;
            if (propDefn.getTypeCode() == 15 || propDefn.getTypeCode() == 19) {
                Object value = element.getLocalProperty(this.module, (ElementPropertyDefn)propDefn);
                if (value == null || !(value instanceof StructRefValue) && !((ElementRefValue)value).isResolved()) continue;
                try {
                    PropertyCommand cmd = new PropertyCommand(this.module, element);
                    cmd.setProperty(propDefn.getName(), null);
                    continue;
                }
                catch (SemanticException semanticException) {
                    assert (false);
                    continue;
                }
            }
            if (propDefn.getTypeCode() != 20 || propDefn.getSubTypeCode() != 15 || (valueList = (List)element.getLocalProperty(this.module, (ElementPropertyDefn)propDefn)) == null) continue;
            CachedMemberRef tmpMemberRef = new CachedMemberRef((ElementPropertyDefn)propDefn);
            int i = valueList.size() - 1;
            while (i >= 0) {
                block9: {
                    ElementRefValue item = (ElementRefValue)valueList.get(i);
                    if (item.isResolved()) {
                        try {
                            ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, element);
                            cmd.removeItem((MemberRef)tmpMemberRef, i);
                        }
                        catch (SemanticException semanticException) {
                            if ($assertionsDisabled) break block9;
                            throw new AssertionError();
                        }
                    }
                }
                --i;
            }
        }
    }

    private void dropUserProperties(DesignElement obj) throws UserPropertyException {
        List props = obj.getLocalUserProperties();
        if (props != null) {
            UserPropertyCommand propCmd = new UserPropertyCommand(this.module, obj);
            for (UserPropertyDefn prop : props) {
                propCmd.dropUserProperty(prop.getName());
            }
        }
    }

    protected void checkBeforeMove(DesignElement content, ContainerContext toContainerInfor) throws ContentException {
        assert (content != null);
        assert (toContainerInfor != null);
        super.checkBeforeMove(content, toContainerInfor);
        if (content.isVirtualElement() || content.getExtendsName() != null) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (this.hasDescendents(content)) {
            throw ContentExceptionFactory.createContentException(new ContainerContext(content, this.focus.getSlotID()), "Error.ContentException.HAS_DESCENDENTS");
        }
    }

    protected void checkBeforeMovePosition(DesignElement content, int newPosn) throws ContentException {
        assert (content != null);
        super.checkBeforeMovePosition(content, newPosn);
        if (content.isVirtualElement()) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (!this.canMovePosition(content, newPosn)) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.MOVE_FORBIDDEN");
        }
    }

    private boolean canMovePosition(DesignElement content, int newPosn) {
        if (this.element instanceof ReportDesign && this.focus.getSlotID() == 5) {
            List derived = content.getDerived();
            for (DesignElement child : derived) {
                if (!this.focus.contains(this.module, child) || this.focus.indexOf(this.module, child) > newPosn) continue;
                return false;
            }
            DesignElement e = content.getExtendsElement();
            while (e != null) {
                if (this.focus.indexOf(this.module, e) >= newPosn) {
                    return false;
                }
                e = e.getExtendsElement();
            }
        }
        return true;
    }

    private boolean hasDescendents(DesignElement content) {
        return this.element instanceof ReportDesign && this.focus.getSlotID() == 5 && content.hasDerived();
    }

    public void transformTemplate(DesignElement from, DesignElement to, boolean unresolveReference) throws SemanticException {
        this.doReplace(from, to, unresolveReference);
    }

    private void doReplace(DesignElement oldElement, DesignElement newElement, boolean unresolveReference) throws SemanticException {
        this.unresolveReference = unresolveReference;
        assert (newElement.getContainer() == null);
        ElementDefn metaData = (ElementDefn)this.element.getDefn();
        if (!metaData.isContainer()) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.NOT_CONTAINER");
        }
        IContainerDefn containerDefn = this.focus.getContainerDefn();
        if (containerDefn == null) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!containerDefn.canContain(newElement)) {
            throw ContentExceptionFactory.createContentException(this.focus, newElement, "Error.ContentException.WRONG_TYPE");
        }
        if (this.element.isContentOf(newElement)) {
            throw ContentExceptionFactory.createContentException(this.focus, newElement, "Error.ContentException.RECURSIVE");
        }
        if (this.focus.getSlotID() == 5 && StringUtil.isBlank(newElement.getName())) {
            throw ContentExceptionFactory.createContentException(this.focus, newElement, "Error.ContentException.CONTENT_NAME_REQUIRED");
        }
        if (!this.focus.contains(this.module, oldElement)) {
            throw ContentExceptionFactory.createContentException(this.focus, oldElement, "Error.ContentException.CONTENT_NOT_FOUND");
        }
        if (oldElement instanceof TemplateElement) {
            if (!(oldElement.canDrop(this.module) && oldElement.isTemplateParameterValue(this.module) && newElement.getDefn().isKindOf(((TemplateElement)oldElement).getDefaultElement(this.module).getDefn()))) {
                throw new TemplateException(oldElement, "Error.TemplateException.REVERT_TO_TEMPLATE_FORBIDDEN");
            }
        } else if (!oldElement.canTransformToTemplate(this.module) || !(newElement instanceof TemplateElement)) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.TEMPLATE_TRANSFORM_FORBIDDEN");
        }
        if (this.hasDescendents(oldElement)) {
            throw ContentExceptionFactory.createContentException(new ContainerContext(oldElement, this.focus.getSlotID()), "Error.ContentException.HAS_DESCENDENTS");
        }
        TemplateTransformRecord replaceRecord = new TemplateTransformRecord(this.module, this.focus, oldElement, newElement);
        ActivityStack stack = this.getActivityStack();
        stack.startFilterEventTrans(replaceRecord.getLabel());
        try {
            this.doDelectAction(oldElement);
            TemplateCommand cmd = new TemplateCommand(this.module, this.focus);
            cmd.checkAdd(newElement);
            stack.execute(replaceRecord);
            this.addElementNames(newElement);
        }
        catch (ContentException e) {
            stack.rollback();
            throw e;
        }
        catch (NameException e) {
            stack.rollback();
            throw e;
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    protected void doDelectAction(DesignElement content) throws SemanticException {
        if (content instanceof ListingElement && content.hasReferences()) {
            this.adjustReferenceClients((IReferencableElement)((Object)content));
        }
        super.doDelectAction(content);
        this.dropUserProperties(content);
        if (!(this.element instanceof ListingElement) && content.hasReferences()) {
            this.adjustReferenceClients((IReferencableElement)((Object)content));
        }
        this.adjustReferredClients(content);
        this.adjustDerived(content);
        if (content.getStyle(this.module) != null) {
            StyleCommand styleCmd = new StyleCommand(this.module, content);
            styleCmd.setStyle(null);
        }
        if (content.getExtendsElement() != null) {
            ExtendsCommand extendsCmd = new ExtendsCommand(this.module, content);
            extendsCmd.setExtendsName(null);
        }
        if (content.getName() != null) {
            NameCommand nameCmd = new NameCommand(this.module, content);
            nameCmd.dropElement();
        }
        List propertyBindings = this.module.getPropertyBindings(content);
        int i = 0;
        while (i < propertyBindings.size()) {
            PropertyBinding propBinding = (PropertyBinding)propertyBindings.get(i);
            ElementPropertyDefn propDefn = this.module.getPropertyDefn("propertyBindings");
            ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.module);
            propCommand.removeItem((MemberRef)new CachedMemberRef(propDefn), propBinding);
            ++i;
        }
    }

    protected void doMove(DesignElement content, ContainerContext toContainerInfor, int newPos) {
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.MoveElement");
        stack.startTrans(label);
        super.doMove(content, toContainerInfor, newPos);
        stack.commit();
    }

    protected void doMovePosition(DesignElement content, int newPosn) throws ContentException {
        int adjustedNewPosn;
        if (!this.focus.isContainerMultipleCardinality()) {
            return;
        }
        int oldPosn = this.focus.indexOf(this.module, content);
        if (oldPosn == (adjustedNewPosn = ContentCommand.checkAndAdjustPosition(oldPosn, newPosn, this.focus.getContentCount(this.module)))) {
            return;
        }
        super.doMovePosition(content, newPosn);
    }
}

