/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;

public class SimpleListValidator
extends AbstractPropertyValidator {
    public static final String NAME = "SimpleListValidator";
    private static SimpleListValidator instance = new SimpleListValidator();

    public static SimpleListValidator getInstance() {
        return instance;
    }

    public List validateForAdding(DesignElementHandle element, IPropertyDefn propDefn, List list, Object toAdd) {
        return this.doCheckPropertyList(element.getModule(), element.getElement(), propDefn, list, toAdd);
    }

    public List validate(Module module, DesignElement element, String propName) {
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        assert (propDefn.getTypeCode() == 20);
        List list = (List)element.getLocalProperty(module, propDefn);
        return this.doCheckPropertyList(module, element, propDefn, list, null);
    }

    private List doCheckPropertyList(Module module, DesignElement element, IPropertyDefn propDefn, List list, Object toAdd) {
        assert (propDefn != null);
        assert (propDefn.getTypeCode() == 20);
        if (list == null || list.size() == 0 || ((PropertyDefn)propDefn).getSubTypeCode() != 15) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyValueException> errorList = new ArrayList<PropertyValueException>();
        HashSet<String> values = new HashSet<String>();
        int i = 0;
        while (i < list.size()) {
            ElementRefValue item = (ElementRefValue)list.get(i);
            String key = item.getQualifiedReference();
            if (values.contains(key)) {
                errorList.add(new PropertyValueException(element, propDefn, (Object)key, "Error.PropertyValueException.VALUE_EXISTS"));
            } else {
                values.add(key);
            }
            ++i;
        }
        if (toAdd != null) {
            assert (toAdd instanceof ElementRefValue);
            String key = ((ElementRefValue)toAdd).getQualifiedReference();
            if (values.contains(key)) {
                errorList.add(new PropertyValueException(element, propDefn, (Object)key, "Error.PropertyValueException.VALUE_EXISTS"));
            }
        }
        return errorList;
    }
}

