/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.metadata;

import java.text.NumberFormat;
import java.util.regex.Pattern;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.util.DimensionValueUtil;

public class DimensionValue {
    protected final double measure;
    protected final String units;
    public static final String DEFAULT_UNIT = "";
    private static final String DOT_SEPARATOR_EXPRESSION = "[\\s]*[-]?[\\d]*([\\d]+[,]?[\\d]+)*[./]?[\\d]*([\\d]+[,]?[\\d]+)*[\\s]*";
    private static final String COMMA_SEPARATOR_EXPRESSION = "[\\s]*[-]?[\\d]*([\\d]+[.]?[\\d]+)*[,]?[\\d]*([\\d]+[.]?[\\d]+)*[\\s]*";
    private static final int MAX_FORMAT_NUMBER = 18;
    public static Pattern dotSeparatorPattern = Pattern.compile("[\\s]*[-]?[\\d]*([\\d]+[,]?[\\d]+)*[./]?[\\d]*([\\d]+[,]?[\\d]+)*[\\s]*");
    public static Pattern commaSeparatorPattern = Pattern.compile("[\\s]*[-]?[\\d]*([\\d]+[.]?[\\d]+)*[,]?[\\d]*([\\d]+[.]?[\\d]+)*[\\s]*");

    public DimensionValue(double theMeasure, String theUnits) {
        this.measure = theMeasure;
        if (StringUtil.isBlank(theUnits)) {
            this.units = DEFAULT_UNIT;
        } else if (DimensionValueUtil.isValidUnit(theUnits)) {
            this.units = theUnits;
        } else {
            throw new IllegalArgumentException("The unit " + theUnits + " is not supported.");
        }
    }

    public double getMeasure() {
        return this.measure;
    }

    public String getUnits() {
        return this.units;
    }

    public static DimensionValue parse(String value) throws PropertyValueException {
        return DimensionValueUtil.doParse(value, false, null);
    }

    public static DimensionValue parseInput(String value) throws PropertyValueException {
        return DimensionValueUtil.doParse(value, true, ThreadResources.getLocale());
    }

    public String toString() {
        String value = StringUtil.doubleToString(this.measure, 18);
        return String.valueOf(value) + this.units;
    }

    public String toDisplayString() {
        NumberFormat nf = NumberFormat.getNumberInstance(ThreadResources.getLocale().toLocale());
        String value = nf.format(this.measure);
        return String.valueOf(value) + this.units;
    }

    public static int indexOfUnitLetter(String value) {
        char[] ch = value.toCharArray();
        int i = 0;
        while (i < ch.length) {
            if (Character.isLetter(ch[i]) || ch[i] == '%') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionValue dv = (DimensionValue)obj;
        return Double.doubleToLongBits(this.measure) == Double.doubleToLongBits(dv.measure) && (this.units == dv.units || this.units != null && this.units.equalsIgnoreCase(dv.units));
    }

    public int hashCode() {
        int result = 17;
        long m = Double.doubleToLongBits(this.getMeasure());
        result = 37 * result + (int)(m ^ m >>> 32);
        if (this.getUnits() != null) {
            int u = this.getUnits().toLowerCase().hashCode();
            result = 37 * result + u;
        }
        return result;
    }
}

