/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableRow;

public class LayoutSlot {
    private static final int NO_GROUP = 0;
    private int groupLevel;
    private List rows;
    private int colCount;
    private int currentRowId;
    private int slotId;
    protected LayoutTable tableContainer;

    protected LayoutSlot(LayoutTable table, int colBufferSize) {
        this(table, 0, colBufferSize);
    }

    protected LayoutSlot(LayoutTable table, int groupId, int colBufferSize) {
        this.groupLevel = groupId;
        this.rows = new ArrayList();
        this.colCount = colBufferSize;
        this.tableContainer = table;
    }

    protected int addCell(int cellPos, int rowSpan, int colSpan, Cell content, boolean isEffectualDrop, int cellId) {
        assert (cellPos > 0);
        int rowId = this.currentRowId;
        int colId = cellPos - 1;
        this.ensureSize(rowId + rowSpan, colId + colSpan);
        this.addOverlappedCells(this.checkOverlappedLayoutCells(rowId, colId, rowSpan, colSpan));
        int id = cellId;
        if (id <= 0) {
            id = this.tableContainer.getNextCellId();
        }
        assert (id > 0);
        this.fillCells(id, rowId, colId, rowSpan, colSpan, content, isEffectualDrop);
        int nextColId = colId + colSpan;
        if (nextColId > this.colCount) {
            this.colCount = nextColId;
        }
        return id;
    }

    protected int addCell(int cellPos, int rowSpan, int colSpan, Cell content, boolean isEffectualDrop) {
        return this.addCell(cellPos, rowSpan, colSpan, content, isEffectualDrop, 0);
    }

    protected List checkOverlappedLayoutCells(int rowId, int colId, int rowSpan, int colSpan) {
        ArrayList retValue = new ArrayList();
        int i = 0;
        while (i < rowSpan) {
            LayoutRow row = (LayoutRow)this.rows.get(rowId + i);
            retValue.addAll(row.checkOverlappedLayoutCells(colId, colSpan));
            ++i;
        }
        return retValue;
    }

    private void fillCells(int cellId, int rowId, int colId, int rowSpan, int colSpan, Cell content, boolean isEffectualDrop) {
        int i = 0;
        while (i < rowSpan) {
            LayoutRow row = (LayoutRow)this.rows.get(rowId + i);
            row.fillCells(cellId, colId, colSpan, i, content, isEffectualDrop);
            ++i;
        }
    }

    protected void addDropSpannedCells(int cellId, int colId, int colSpan, int rowSpanOffset, Cell content) {
        this.addOverlappedCells(this.checkOverlappedLayoutCells(0, colId, this.getRowCount(), colSpan));
        int i = 0;
        while (i < this.rows.size()) {
            LayoutRow row = (LayoutRow)this.rows.get(i);
            row.fillDropSpannedCells(cellId, colId, colSpan, i + 1, content);
            ++i;
        }
    }

    private void addOverlappedCells(List overlappedAreas) {
        if (!overlappedAreas.isEmpty()) {
            int i = 0;
            while (i < overlappedAreas.size()) {
                LayoutCell layoutCell = (LayoutCell)overlappedAreas.get(i);
                LayoutRow layoutRow = layoutCell.getLayoutContainer();
                this.tableContainer.addOverlappedCell(layoutCell.getContent(), this, layoutRow.getRowPosn(), layoutCell.getColumnPosn(), layoutCell.getRowSpanOffset(), layoutCell.getColumnSpanOffset());
                ++i;
            }
        }
    }

    protected void ensureSize(int newRowCount, int newColumnCount) {
        int colId;
        LayoutRow row;
        int rowId;
        int rowCount = this.rows.size();
        if (newRowCount > rowCount) {
            rowId = rowCount;
            while (rowId < newRowCount) {
                row = new LayoutRow(this, rowId);
                colId = 0;
                while (colId < this.colCount) {
                    row.addCell(LayoutCell.EMPTY_CELL);
                    ++colId;
                }
                this.rows.add(row);
                ++rowId;
            }
        }
        rowCount = this.rows.size();
        if (newColumnCount > this.colCount) {
            rowId = 0;
            while (rowId < rowCount) {
                row = (LayoutRow)this.rows.get(rowId);
                colId = this.colCount;
                while (colId < newColumnCount) {
                    row.addCell(LayoutCell.EMPTY_CELL);
                    ++colId;
                }
                ++rowId;
            }
        }
    }

    protected void newLayoutRow(TableRow row) {
        int rowCount = this.rows.size();
        if (rowCount == 0 || rowCount == this.currentRowId + 1) {
            this.ensureSize(rowCount + 1, this.colCount);
        }
        if (rowCount != 0) {
            ++this.currentRowId;
        }
        ++rowCount;
    }

    protected int getColumnCount() {
        return this.colCount;
    }

    protected LayoutRow getLayoutRow(int rowId) {
        if (rowId >= this.rows.size()) {
            return null;
        }
        return (LayoutRow)this.rows.get(rowId);
    }

    protected LayoutRow getCurrentLayoutRow() {
        return this.getLayoutRow(this.currentRowId);
    }

    protected int getGroupLevel() {
        return this.groupLevel;
    }

    public int getRowCount() {
        if (this.rows.isEmpty()) {
            return 0;
        }
        return this.currentRowId + 1;
    }

    protected int getColumnPos(int rowId, Cell cell) {
        if (rowId < 0 || rowId >= this.rows.size()) {
            return 0;
        }
        LayoutRow row = this.getLayoutRow(rowId);
        return row.findCellColumnPos(cell);
    }

    public LayoutCell getLayoutCell(int rowId, int colId) {
        if (rowId < 0 || rowId > this.getRowCount() - 1) {
            return null;
        }
        LayoutRow row = this.getLayoutRow(rowId);
        return row.getLayoutCell(colId);
    }

    protected LayoutCell getLayoutCell(int rowId, CellHandle cell) {
        if (rowId < 0 || rowId > this.getRowCount() - 1) {
            return null;
        }
        LayoutRow row = this.getLayoutRow(rowId);
        return row.getLayoutCell(cell);
    }

    public String getLayoutString() {
        if (this.rows.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.rows.size()) {
            LayoutRow row = (LayoutRow)this.rows.get(i);
            sb.append(row.getLayoutString());
            ++i;
        }
        return sb.toString();
    }

    public SlotHandle getSlot() {
        if (this.groupLevel == 0) {
            return new SlotHandle(this.tableContainer.getTable(), this.slotId);
        }
        SlotHandle slots = this.tableContainer.getTable().getGroups();
        TableGroupHandle group = (TableGroupHandle)slots.get(this.groupLevel);
        return group.getSlot(this.slotId);
    }

    public TableGroupHandle getGroup() {
        if (this.groupLevel < 1) {
            return null;
        }
        SlotHandle slots = this.tableContainer.getTable().getGroups();
        TableGroupHandle group = (TableGroupHandle)slots.get(this.groupLevel);
        return group;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public Iterator layoutRowsIterator() {
        return new ArrayList(this.rows.subList(0, this.currentRowId)).iterator();
    }

    public Iterator rowsIterator() {
        LinkedHashSet<RowHandle> retValue = new LinkedHashSet<RowHandle>();
        int i = 0;
        while (i < this.currentRowId) {
            LayoutRow row = (LayoutRow)this.rows.get(i);
            retValue.add(row.getRow());
            ++i;
        }
        return retValue.iterator();
    }
}

