/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.schema;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.doc.schema.CssType;
import org.eclipse.birt.doc.schema.IFilter;
import org.eclipse.birt.doc.schema.ISchemaWriter;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;

public class SchemaUtil {
    public static boolean isBlank(String astr) {
        return astr == null || astr.trim().length() == 0;
    }

    private static String transform(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        input = input.trim();
        int len = input.length();
        int i = 0;
        while (i < len) {
            char c = input.charAt(i);
            if ('A' <= c && c <= 'Z') {
                buffer.append("-");
                c = (char)(c - 65 + 97);
            }
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    private static void preWrite(Map cssMap, IElementDefn styleDefn, ISchemaWriter writer) {
    }

    private static void postWrite(Map cssMap, IElementDefn styleDefn, ISchemaWriter writer) {
        String allowedValue = "[ [ left | center | right ] || [ top | center | bottom ] ]";
        CssType css = new CssType();
        String name = "background-position";
        css.setName(name);
        css.setBirtChoiceValues(allowedValue);
        css.setInitialValues(null);
        String cssValue = (String)cssMap.get(name);
        css.setValues(cssValue);
        writer.writeRow(css);
        allowedValue = "underline | overline | line-through ";
        CssType textDecoCss = new CssType();
        name = "text-decoration";
        textDecoCss.setName(name);
        textDecoCss.setBirtChoiceValues(allowedValue);
        textDecoCss.setInitialValues(null);
        cssValue = (String)cssMap.get(name);
        textDecoCss.setValues(cssValue);
        writer.writeRow(textDecoCss);
    }

    public static void writeSchema(IMetaDataDictionary dictionary, ISchemaWriter writer, IFilter filter, Map cssMap) {
        assert (dictionary != null);
        assert (writer != null);
        assert (filter != null);
        assert (cssMap != null);
        ElementDefn styleDefn = (ElementDefn)dictionary.getElement("Style");
        if (styleDefn == null) {
            return;
        }
        writer.startHtml();
        SchemaUtil.preWrite(cssMap, styleDefn, writer);
        Iterator iterator = styleDefn.propertiesIterator();
        while (iterator.hasNext()) {
            SystemPropertyDefn propDefn = (SystemPropertyDefn)iterator.next();
            if (!propDefn.isStyleProperty()) continue;
            String propName = propDefn.getName();
            propName = SchemaUtil.transform(propName);
            Object defaultValue = propDefn.getDefault();
            if (defaultValue != null) {
                defaultValue = defaultValue.toString();
            }
            if (!filter.filter(propDefn)) continue;
            IChoiceSet propChoice = propDefn.getChoices();
            CssType css = new CssType();
            css.setName(propName);
            css.setInitialValues((String)defaultValue);
            String cssValue = (String)cssMap.get(propName);
            css.setValues(cssValue);
            if (propChoice == null) {
                writer.writeRow(css);
                continue;
            }
            IChoice[] choices = propChoice.getChoices();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < choices.length) {
                IChoice choice = choices[i];
                String choiceName = choice.getName();
                buffer.append("|");
                buffer.append(choiceName);
                ++i;
            }
            String allowedValue = buffer.toString();
            if (allowedValue.length() != 0) {
                allowedValue = allowedValue.substring(1);
            }
            css.setBirtChoiceValues(allowedValue);
            writer.writeRow(css);
        }
        SchemaUtil.postWrite(cssMap, styleDefn, writer);
        writer.closeHtml();
        writer.close();
    }
}

