/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.schema;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.birt.doc.schema.CSSDocParser;
import org.eclipse.birt.doc.schema.CssSchemaWriter;
import org.eclipse.birt.doc.schema.CssStyleFilter;
import org.eclipse.birt.doc.schema.SchemaUtil;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaDataReader;

public class SchemaDoc {
    private static String outputDir = "romdoc/gen/css";
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        CSSDocParser parser = new CSSDocParser();
        try {
            parser.parse();
            Map cssMap = parser.cssMap;
            try {
                SchemaDoc.loadModel();
            }
            catch (MetaDataParserException metaDataParserException) {
                return;
            }
            MetaDataDictionary dict = MetaDataDictionary.getInstance();
            CssSchemaWriter writer = null;
            try {
                File output = SchemaDoc.makeFile("CssProperty.html");
                writer = new CssSchemaWriter(output);
                CssStyleFilter filter = new CssStyleFilter();
                SchemaUtil.writeSchema(dict, writer, filter, cssMap);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        catch (CSSDocParser.ParseException e1) {
            e1.printStackTrace();
        }
    }

    private static File makeFile(String fileName) throws IOException {
        File output;
        File dir = new File(String.valueOf(outputDir) + "/");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(output = new File(dir, fileName)).exists()) {
            output.createNewFile();
        }
        return output;
    }

    private static void loadModel() throws MetaDataParserException {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.model.elements.ReportDesign");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MetaDataReader.read(clazz.getResourceAsStream("rom.def"));
        }
        catch (MetaDataParserException e) {
            System.out.println("rom.def load failed.");
            throw e;
        }
    }
}

