/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.impl.ParameterDefn;
import org.eclipse.birt.report.engine.api.impl.ParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.impl.SelectionChoiceComparator;

public class ScalarParameterDefn
extends ParameterDefn
implements IScalarParameterDefn {
    protected boolean cancealValue;
    protected boolean allowNull;
    protected boolean allowBlank;
    protected boolean isRequired;
    protected String displayFormat;
    protected int controlType;
    protected int alignment;
    protected ArrayList selectionList;
    protected boolean fixedOrder;
    protected int parameterType;
    protected int selectionListType;
    protected int dataType;
    protected boolean allowNewValues;
    protected String defaultValue;
    protected String scalarParameterType;
    protected int autoSuggestThreshold;
    protected Logger log = Logger.getLogger(ScalarParameterDefn.class.getName());

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public boolean isValueConcealed() {
        return this.cancealValue;
    }

    public void setValueConcealed(boolean valueConceal) {
        this.cancealValue = valueConceal;
    }

    public boolean allowNull() {
        return !this.isRequired();
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public boolean allowBlank() {
        return !this.isRequired();
    }

    public void setAllowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public void setFormat(String format) {
        this.displayFormat = format;
    }

    public int getControlType() {
        return this.controlType;
    }

    public void setControlType(int controlType) {
        this.controlType = controlType;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public ArrayList getSelectionList() {
        return this.selectionList;
    }

    public int getSelectionListType() {
        return this.selectionListType;
    }

    public boolean displayInFixedOrder() {
        return this.fixedOrder;
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public Map getUserPropertyValues() {
        return null;
    }

    public String getUserPropertyValue(String name) {
        return null;
    }

    public void setFixedOrder(boolean fixedOrder) {
        this.fixedOrder = fixedOrder;
    }

    public void setParameterType(int parameterType) {
        this.parameterType = parameterType;
    }

    public void setSelectionListType(int selectionListType) {
        this.selectionListType = selectionListType;
    }

    public void setSelectionList(ArrayList paramSelectionList) {
        this.selectionList = paramSelectionList;
    }

    public Object clone() throws CloneNotSupportedException {
        Object newObj = super.clone();
        ScalarParameterDefn para = (ScalarParameterDefn)newObj;
        ArrayList list = para.getSelectionList();
        if (list == null) {
            return para;
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            ParameterSelectionChoice select = (ParameterSelectionChoice)list.get(i);
            newList.add(select.clone());
            ++i;
        }
        para.setSelectionList(newList);
        return para;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public boolean allowNewValues() {
        return this.allowNewValues;
    }

    public void setAllowNewValues(boolean allowNewValues) {
        this.allowNewValues = allowNewValues;
    }

    public void evaluateSelectionList() {
        if (this.selectionListType == 2) {
            boolean sortDisplayValue = true;
            int i = 0;
            while (i < this.selectionList.size()) {
                ParameterSelectionChoice choice = (ParameterSelectionChoice)this.selectionList.get(i);
                choice.setLocale(this.locale);
                if (choice.getLabel() == null) {
                    sortDisplayValue = false;
                    break;
                }
                ++i;
            }
            if (!this.fixedOrder) {
                Collections.sort(this.selectionList, new SelectionChoiceComparator(sortDisplayValue, this.displayFormat, ULocale.forLocale((Locale)this.locale)));
            }
        }
    }

    public String getScalarParameterType() {
        return this.scalarParameterType;
    }

    public void setScalarParameterType(String type) {
        this.scalarParameterType = type;
    }

    public void setAutoSuggestThreshold(int value) {
        this.autoSuggestThreshold = value;
    }

    public int getAutoSuggestThreshold() {
        return this.autoSuggestThreshold;
    }
}

