/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.style;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.style.IStyle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class SimpleStyle
implements IStyle {
    private FontDefinition font;
    private ColorDefinition color;
    private ColorDefinition backcolor;
    private Image backimage;
    private Insets padding;

    public SimpleStyle() {
    }

    public SimpleStyle(FontDefinition font, ColorDefinition color, ColorDefinition backcolor, Image backimage, Insets padding) {
        this.setFont(font);
        this.setColor(color);
        this.setBackgroundColor(backcolor);
        this.setBackgroundImage(backimage);
        this.setPadding(padding);
    }

    public SimpleStyle(IStyle src) {
        if (src != null) {
            if (src.getFont() != null) {
                this.setFont(FontDefinitionImpl.copyInstance(src.getFont()));
            }
            if (src.getColor() != null) {
                this.setColor(ColorDefinitionImpl.copyInstance(src.getColor()));
            }
            if (src.getBackgroundColor() != null) {
                this.setBackgroundColor(ColorDefinitionImpl.copyInstance(src.getBackgroundColor()));
            }
            if (src.getBackgroundImage() != null) {
                this.setBackgroundImage((Image)EcoreUtil.copy((EObject)src.getBackgroundImage()));
            }
            if (src.getPadding() != null) {
                this.setPadding(InsetsImpl.copyInstance(src.getPadding()));
            }
        }
    }

    public SimpleStyle copy() {
        SimpleStyle ss = new SimpleStyle();
        if (this.font != null) {
            ss.setFont(FontDefinitionImpl.copyInstance(this.font));
        }
        if (this.color != null) {
            ss.setColor(ColorDefinitionImpl.copyInstance(this.color));
        }
        if (this.backcolor != null) {
            ss.setBackgroundColor(ColorDefinitionImpl.copyInstance(this.backcolor));
        }
        if (this.backimage != null) {
            ss.setBackgroundImage((Image)EcoreUtil.copy((EObject)this.backimage));
        }
        if (this.padding != null) {
            ss.setPadding(InsetsImpl.copyInstance(this.padding));
        }
        return ss;
    }

    public void setFont(FontDefinition font) {
        this.font = font;
    }

    public void setColor(ColorDefinition color) {
        this.color = color;
    }

    public void setBackgroundColor(ColorDefinition backcolor) {
        this.backcolor = backcolor;
    }

    public void setBackgroundImage(Image backimage) {
        this.backimage = backimage;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public FontDefinition getFont() {
        return this.font;
    }

    public ColorDefinition getBackgroundColor() {
        return this.backcolor;
    }

    public Image getBackgroundImage() {
        return this.backimage;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public ColorDefinition getColor() {
        return this.color;
    }
}

