/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.internal.datafeed.DataProcessor;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.emf.common.util.EList;

public class GroupingLookupHelper {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/trace");
    private LinkedHashMap lhmAggExp = new LinkedHashMap(8);
    private List lstAll = new ArrayList(8);
    private String strBaseAggExp = null;
    private int iLookup = 0;
    private ULocale locale;

    public GroupingLookupHelper(Chart cm, IActionEvaluator iae, ULocale locale) throws ChartException {
        this.locale = locale;
        if (cm instanceof ChartWithAxes) {
            this.initRowExpressions((ChartWithAxes)cm, iae);
        } else if (cm instanceof ChartWithoutAxes) {
            this.initRowExpressions((ChartWithoutAxes)cm, iae);
        }
    }

    public GroupingLookupHelper(Collection dataExps, Collection aggExps) {
        Iterator dataIterator = dataExps.iterator();
        Iterator aggIterator = aggExps.iterator();
        while (dataIterator.hasNext() && aggIterator.hasNext()) {
            String dataExp = (String)dataIterator.next();
            String aggExp = (String)aggIterator.next();
            this.lstAll.add(dataExp);
            this.lhmAggExp.put(this.generateKey(dataExp, aggExp), new Integer(this.iLookup++));
        }
    }

    public List getExpressions() {
        return this.lstAll;
    }

    private String generateKey(String dataExp, String aggExp) {
        if (aggExp == null) {
            return dataExp;
        }
        return String.valueOf(dataExp) + "_" + aggExp;
    }

    public int findIndexOfBaseSeries(String dataExp) {
        return this.findIndex(dataExp, "");
    }

    public int findIndex(String dataExp, String aggExp) {
        Object value = null;
        value = aggExp == null ? this.lhmAggExp.get(this.generateKey(dataExp, this.strBaseAggExp)) : this.lhmAggExp.get(this.generateKey(dataExp, aggExp));
        return value instanceof Integer ? (Integer)value : -1;
    }

    public int[] findBatchIndex(String[] dataExpArray, String aggExp) {
        int[] indexArray = new int[dataExpArray.length];
        int i = 0;
        while (i < indexArray.length) {
            indexArray[i] = this.findIndex(dataExpArray[i], aggExp);
            ++i;
        }
        return indexArray;
    }

    private boolean addDataExpOfBaseSeries(String dataExp) {
        return this.addDataExp(dataExp, "");
    }

    private boolean addDataExp(String dataExp, String aggExp) {
        if (dataExp != null && dataExp.trim().length() > 0) {
            String key = this.generateKey(dataExp, aggExp);
            if (!this.lhmAggExp.containsKey(key)) {
                this.lhmAggExp.put(key, new Integer(this.iLookup++));
                this.lstAll.add(dataExp);
            }
            return true;
        }
        return false;
    }

    private void addLookupForBaseSeries(SeriesDefinition baseSD) throws ChartException {
        Series seBase;
        EList elBaseSeries;
        Query qBaseSeriesDefinition = baseSD.getQuery();
        String sExpression = qBaseSeriesDefinition.getDefinition();
        if (sExpression != null && sExpression.trim().length() > 0) {
            logger.log(2, Messages.getString("dataprocessor.log.baseSeriesDefn3", sExpression, ULocale.getDefault()));
        }
        if ((elBaseSeries = (seBase = baseSD.getDesignTimeSeries()).getDataDefinition()).size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.FoundDefnAssociatedWithX", new Object[]{String.valueOf(elBaseSeries.size())}, Messages.getResourceBundle(this.locale));
        }
        if (!this.addDataExpOfBaseSeries(((Query)elBaseSeries.get(0)).getDefinition())) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.DefinitionUnspecified", Messages.getResourceBundle(this.locale));
        }
    }

    private void addLookupForOrthogonalSeries(EList lstOrthogonalSDs, IActionEvaluator iae) throws ChartException {
        int k = 0;
        while (k < lstOrthogonalSDs.size()) {
            SeriesDefinition orthoSD = (SeriesDefinition)lstOrthogonalSDs.get(k);
            Query qOrthogonalSeriesDefinition = orthoSD.getQuery();
            if (qOrthogonalSeriesDefinition == null) {
                return;
            }
            String strOrthoAgg = this.getOrthogonalAggregationExpression(orthoSD);
            this.addDataExp(qOrthogonalSeriesDefinition.getDefinition(), strOrthoAgg);
            Series seOrthogonal = orthoSD.getDesignTimeSeries();
            EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
            if (elOrthogonalSeries.isEmpty()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.DefnExpMustAssociateY", new Object[]{String.valueOf(k), seOrthogonal}, Messages.getResourceBundle(this.locale));
            }
            boolean bAnyQueries = false;
            int i = 0;
            while (i < elOrthogonalSeries.size()) {
                Query qOrthogonalSeries = (Query)elOrthogonalSeries.get(i);
                if (qOrthogonalSeries != null && this.addDataExp(qOrthogonalSeries.getDefinition(), strOrthoAgg)) {
                    bAnyQueries = true;
                }
                ++i;
            }
            if (!bAnyQueries) {
                throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.AtLeastOneDefnExpMustAssociateY", new Object[]{String.valueOf(k), seOrthogonal}, Messages.getResourceBundle(this.locale));
            }
            String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonal, iae);
            if (triggerExprs != null) {
                int t = 0;
                while (t < triggerExprs.length) {
                    this.addDataExp(triggerExprs[t], strOrthoAgg);
                    ++t;
                }
            }
            ++k;
        }
    }

    private void initRowExpressions(ChartWithoutAxes cwoa, IActionEvaluator iae) throws ChartException {
        EList elSD = cwoa.getSeriesDefinitions();
        if (elSD.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.CannotDecipher", Messages.getResourceBundle(this.locale));
        }
        SeriesDefinition baseSD = (SeriesDefinition)elSD.get(0);
        this.strBaseAggExp = GroupingLookupHelper.getAggregationExpression(baseSD);
        this.addLookupForBaseSeries(baseSD);
        this.addLookupForOrthogonalSeries(baseSD.getSeriesDefinitions(), iae);
    }

    private void initRowExpressions(ChartWithAxes cwa, IActionEvaluator iae) throws ChartException {
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        if (elSD.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "dataprocessor.exception.CannotDecipher2", Messages.getResourceBundle(this.locale));
        }
        SeriesDefinition baseSD = (SeriesDefinition)elSD.get(0);
        this.strBaseAggExp = GroupingLookupHelper.getAggregationExpression(baseSD);
        this.addLookupForBaseSeries(baseSD);
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int j = 0;
        while (j < axaOrthogonal.length) {
            this.addLookupForOrthogonalSeries(axaOrthogonal[j].getSeriesDefinitions(), iae);
            ++j;
        }
    }

    static String getAggregationExp(SeriesDefinition baseSD, SeriesDefinition orthoSD) {
        boolean bBaseGroupEnabled = baseSD.getGrouping().isEnabled();
        String strOrthoAgg = null;
        if (bBaseGroupEnabled) {
            String strBaseAgg = baseSD.getGrouping().getAggregateExpression();
            boolean bOrthoGroupEnabled = orthoSD.getGrouping().isEnabled();
            strOrthoAgg = bOrthoGroupEnabled ? orthoSD.getGrouping().getAggregateExpression() : strBaseAgg;
        }
        return strOrthoAgg;
    }

    static String getAggregationExpression(SeriesDefinition sd) {
        SeriesGrouping grouping = sd.getGrouping();
        if (grouping.isSetEnabled() && grouping.isEnabled()) {
            return grouping.getAggregateExpression();
        }
        return null;
    }

    public String getOrthogonalAggregationExpression(SeriesDefinition orthoSD) {
        String strOrthoAgg = null;
        SeriesGrouping grouping = orthoSD.getGrouping();
        if (this.strBaseAggExp != null) {
            strOrthoAgg = grouping.isSetEnabled() && grouping.isEnabled() ? grouping.getAggregateExpression() : this.strBaseAggExp;
        }
        return strOrthoAgg;
    }
}

