/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UnionVersionRange
implements VersionRange {
    private final Set<VersionRange> ranges;

    public static VersionRange from(VersionRange ... ranges) {
        if (ranges == null) {
            return UnionVersionRange.from(Collections.emptySet());
        }
        return UnionVersionRange.from(Arrays.asList(ranges));
    }

    public static VersionRange from(Collection<? extends VersionRange> ranges) {
        if (ranges != null && ranges.size() == 1) {
            return ranges.iterator().next();
        }
        return new UnionVersionRange(ranges);
    }

    private UnionVersionRange(Collection<? extends VersionRange> ranges) {
        this.ranges = ranges == null || ranges.isEmpty() ? Collections.emptySet() : new HashSet<VersionRange>(ranges);
    }

    public boolean containsVersion(Version version) {
        for (VersionRange range : this.ranges) {
            if (!range.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        UnionVersionRange that = (UnionVersionRange)obj;
        return this.ranges.equals(that.ranges);
    }

    public int hashCode() {
        int hash = 97 * this.ranges.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        for (VersionRange range : this.ranges) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(range);
        }
        return buffer.toString();
    }
}

