/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.selector;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScopeDependencySelector
implements DependencySelector {
    private final boolean transitive;
    private final Set<String> included;
    private final Set<String> excluded;

    public ScopeDependencySelector(Collection<String> included, Collection<String> excluded) {
        this.transitive = false;
        if (included != null) {
            this.included = new HashSet<String>();
            this.included.addAll(included);
        } else {
            this.included = Collections.emptySet();
        }
        if (excluded != null) {
            this.excluded = new HashSet<String>();
            this.excluded.addAll(excluded);
        } else {
            this.excluded = Collections.emptySet();
        }
    }

    public ScopeDependencySelector(String ... excluded) {
        this(null, Arrays.asList(excluded));
    }

    private ScopeDependencySelector(boolean transitive, Set<String> included, Set<String> excluded) {
        this.transitive = transitive;
        this.included = included;
        this.excluded = excluded;
    }

    public boolean selectDependency(Dependency dependency) {
        if (!this.transitive) {
            return true;
        }
        String scope = dependency.getScope();
        return !(!this.included.isEmpty() && !this.included.contains(scope) || !this.excluded.isEmpty() && this.excluded.contains(scope));
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.transitive || context.getDependency() == null) {
            return this;
        }
        return new ScopeDependencySelector(true, this.included, this.excluded);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencySelector that = (ScopeDependencySelector)obj;
        return this.transitive == that.transitive && this.included.equals(that.included) && this.excluded.equals(that.excluded);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.transitive ? 1 : 0);
        hash = hash * 31 + this.included.hashCode();
        hash = hash * 31 + this.excluded.hashCode();
        return hash;
    }
}

