/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.internal.test.impl.TestAuthenticationSelector;
import org.eclipse.aether.internal.test.impl.TestLocalRepositoryManager;
import org.eclipse.aether.internal.test.impl.TestProxySelector;
import org.eclipse.aether.internal.test.impl.TestSessionData;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicyRequest;
import org.eclipse.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRepositorySystemSession
implements RepositorySystemSession {
    private SessionData data = new TestSessionData();
    private TransferListener listener;
    private RepositoryListener repositoryListener;
    private AuthenticationSelector authenticator = new TestAuthenticationSelector();
    private ProxySelector proxySelector = new TestProxySelector();
    private LocalRepositoryManager localRepositoryManager;
    private ResolutionErrorPolicy resolutionErrorPolicy = new TestResolutionErrorPolicy();
    private boolean transferErrorCaching;
    private boolean notFoundCaching;
    private DependencyManager dependencyManager;
    private Map<String, Object> configProperties = new HashMap<String, Object>();
    private boolean offline;
    private String updatePolicy = "always";
    private String checksumPolicy = "fail";
    private MirrorSelector mirrorSelector;

    public TestRepositorySystemSession() throws IOException {
        this.localRepositoryManager = new TestLocalRepositoryManager();
    }

    public TransferListener getTransferListener() {
        return this.listener;
    }

    public Map<String, Object> getConfigProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    public void setConfigProperties(Map<String, Object> configProperties) {
        this.configProperties = configProperties == null ? Collections.emptyMap() : configProperties;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public ResolutionErrorPolicy getResolutionErrorPolicy() {
        return this.resolutionErrorPolicy;
    }

    public ArtifactDescriptorPolicy getArtifactDescriptorPolicy() {
        return null;
    }

    public boolean isIgnoreArtifactDescriptorRepositories() {
        return false;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public void setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public LocalRepository getLocalRepository() {
        return this.localRepositoryManager.getRepository();
    }

    public LocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepositoryManager;
    }

    public WorkspaceReader getWorkspaceReader() {
        return null;
    }

    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public Map<String, String> getSystemProperties() {
        return Collections.emptyMap();
    }

    public Map<String, String> getUserProperties() {
        return Collections.emptyMap();
    }

    public MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public void setMirrorSelector(MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public void setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }

    public AuthenticationSelector getAuthenticationSelector() {
        return this.authenticator;
    }

    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return null;
    }

    public DependencyTraverser getDependencyTraverser() {
        return new DependencyTraverser(){

            public boolean traverseDependency(Dependency dependency) {
                return true;
            }

            public DependencyTraverser deriveChildTraverser(DependencyCollectionContext context) {
                return this;
            }
        };
    }

    public DependencyManager getDependencyManager() {
        if (this.dependencyManager == null) {
            return new DependencyManager(){

                public DependencyManagement manageDependency(Dependency dependency) {
                    return null;
                }

                public DependencyManager deriveChildManager(DependencyCollectionContext context) {
                    return this;
                }
            };
        }
        return this.dependencyManager;
    }

    public DependencySelector getDependencySelector() {
        return new DependencySelector(){

            public boolean selectDependency(Dependency dependency) {
                return true;
            }

            public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
                return this;
            }
        };
    }

    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return new DependencyGraphTransformer(){

            public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
                return node;
            }
        };
    }

    public SessionData getData() {
        return this.data;
    }

    public RepositoryCache getCache() {
        return null;
    }

    public void setRepositoryListener(RepositoryListener repositoryListener) {
        this.repositoryListener = repositoryListener;
    }

    public void setTransferListener(TransferListener listener) {
        this.listener = listener;
    }

    public void setTransferErrorCachingEnabled(boolean b) {
        this.transferErrorCaching = b;
    }

    public void setNotFoundCachingEnabled(boolean b) {
        this.notFoundCaching = b;
    }

    public void setLocalRepositoryManager(LocalRepositoryManager localRepositoryManager) {
        this.localRepositoryManager = localRepositoryManager;
    }

    public void setDependencyManager(DependencyManager manager) {
        this.dependencyManager = manager;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestResolutionErrorPolicy
    implements ResolutionErrorPolicy {
        private TestResolutionErrorPolicy() {
        }

        public int getArtifactPolicy(RepositorySystemSession session, ResolutionErrorPolicyRequest<Artifact> request) {
            return this.getPolicy();
        }

        public int getMetadataPolicy(RepositorySystemSession session, ResolutionErrorPolicyRequest<Metadata> request) {
            return this.getPolicy();
        }

        private int getPolicy() {
            return (TestRepositorySystemSession.this.notFoundCaching ? 1 : 0) | (TestRepositorySystemSession.this.transferErrorCaching ? 2 : 0);
        }
    }
}

