/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.Response;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.async.TransferException;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompletionHandler
implements ProgressAsyncHandler<Response> {
    private final Logger logger;
    private HttpResponseStatus status;
    private HttpResponseHeaders headers;
    private final ConcurrentLinkedQueue<TransferListener> listeners = new ConcurrentLinkedQueue();
    private final AsyncHttpClient httpClient;
    private final AtomicLong byteTransfered = new AtomicLong();
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private final TransferResource transferResource;
    private final TransferEvent.RequestType requestType;
    private final TransferEvent.Builder eventBuilder;

    public CompletionHandler(TransferResource transferResource, AsyncHttpClient httpClient, Logger logger, TransferEvent.RequestType requestType, RepositorySystemSession session) {
        this.httpClient = httpClient;
        this.transferResource = transferResource;
        this.logger = logger;
        this.requestType = requestType;
        this.eventBuilder = new TransferEvent.Builder(session, transferResource).setRequestType(requestType);
    }

    public AsyncHandler.STATE onHeaderWriteCompleted() {
        if (TransferEvent.RequestType.PUT.equals((Object)this.requestType)) {
            this.byteTransfered.set(0L);
            try {
                this.fireTransferStarted();
            }
            catch (TransferCancelledException e) {
                return AsyncHandler.STATE.ABORT;
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onContentWriteCompleted() {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onContentWriteProgress(long amount, long current, long total) {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        block3: {
            try {
                this.fireTransferProgressed(content.getBodyPartBytes());
            }
            catch (TransferCancelledException e) {
                return AsyncHandler.STATE.ABORT;
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug("", (Throwable)ex);
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.status = status;
        return status.getStatusCode() == 404 ? AsyncHandler.STATE.ABORT : AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.headers = headers;
        if (!TransferEvent.RequestType.PUT.equals((Object)this.requestType) && this.status.getStatusCode() >= 200 && this.status.getStatusCode() < 300) {
            try {
                this.transferResource.setContentLength(Long.parseLong(headers.getHeaders().getFirstValue("Content-Length")));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                this.fireTransferStarted();
            }
            catch (TransferCancelledException e) {
                return AsyncHandler.STATE.ABORT;
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public final Response onCompleted() throws Exception {
        if (this.status == null) {
            throw new TransferException("Invalid AHC State. Response will possibly gets corrupted.");
        }
        return this.onCompleted(this.httpClient.getProvider().prepareResponse(this.status, this.headers, Collections.emptyList()));
    }

    public void onThrowable(Throwable t) {
        this.exception.set(t);
    }

    public Response onCompleted(Response response) throws Exception {
        if (response != null && response.hasResponseStatus() && response.getStatusCode() >= 200 && response.getStatusCode() <= 201) {
            this.fireTransferSucceeded(response);
        }
        return response;
    }

    void fireTransferProgressed(byte[] buffer) throws TransferCancelledException {
        this.fireTransferProgressed(ByteBuffer.wrap(buffer));
    }

    void fireTransferProgressed(ByteBuffer buffer) throws TransferCancelledException {
        long bytesTransferred = this.byteTransfered.addAndGet(buffer.remaining());
        TransferEvent transferEvent = this.newEvent(TransferEvent.EventType.PROGRESSED).setTransferredBytes(bytesTransferred).setDataBuffer(buffer).build();
        for (TransferListener listener : this.listeners) {
            listener.transferProgressed(transferEvent);
        }
    }

    void fireTransferSucceeded(Response response) throws IOException {
        long bytesTransferred = this.byteTransfered.get();
        TransferEvent transferEvent = this.newEvent(TransferEvent.EventType.SUCCEEDED).setTransferredBytes(bytesTransferred).build();
        for (TransferListener listener : this.listeners) {
            listener.transferSucceeded(transferEvent);
        }
    }

    void fireTransferFailed() throws IOException {
        long bytesTransferred = this.byteTransfered.get();
        TransferEvent transferEvent = this.newEvent(TransferEvent.EventType.FAILED).setTransferredBytes(bytesTransferred).build();
        for (TransferListener listener : this.listeners) {
            listener.transferFailed(transferEvent);
        }
    }

    void fireTransferStarted() throws TransferCancelledException {
        TransferEvent transferEvent = this.newEvent(TransferEvent.EventType.STARTED).setTransferredBytes(0L).build();
        for (TransferListener listener : this.listeners) {
            listener.transferStarted(transferEvent);
        }
    }

    public boolean addTransferListener(TransferListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.offer(listener);
    }

    public boolean removeTransferListener(TransferListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    protected HttpResponseStatus status() {
        return this.status;
    }

    private TransferEvent.Builder newEvent(TransferEvent.EventType type) {
        Throwable t = this.exception.get();
        return this.eventBuilder.copy().setType(type).setException(t instanceof Exception ? (Exception)t : new Exception(t));
    }
}

