/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.async.AuthorizationException;
import org.eclipse.aether.connector.async.CompletionHandler;
import org.eclipse.aether.connector.async.ProgressingFileBodyGenerator;
import org.eclipse.aether.connector.async.ResourceDoesNotExistException;
import org.eclipse.aether.connector.async.TransferException;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataTransfer;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.Transfer;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.StringUtils;
import org.eclipse.aether.util.repository.layout.MavenDefaultLayout;
import org.eclipse.aether.util.repository.layout.RepositoryLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncRepositoryConnector
implements RepositoryConnector {
    private final Logger logger;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final AsyncHttpClient httpClient;
    private final Map<String, String> checksumAlgos;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final RepositoryLayout layout = new MavenDefaultLayout();
    private final TransferListener listener;
    private final RepositorySystemSession session;
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private boolean useCache = false;
    private final boolean disableResumeSupport;
    private static final ConcurrentHashMap<RandomAccessFile, Boolean> activeDownloadFiles = new ConcurrentHashMap();
    private final int maxIOExceptionRetry;
    private final FluentCaseInsensitiveStringsMap headers;
    private static final ExceptionWrapper<MetadataTransfer> METADATA = new ExceptionWrapper<MetadataTransfer>(){

        @Override
        public void wrap(MetadataTransfer transfer, Exception e, RemoteRepository repository) {
            MetadataNotFoundException ex = null;
            if (e instanceof ResourceDoesNotExistException) {
                ex = new MetadataNotFoundException(transfer.getMetadata(), repository);
            } else if (e != null) {
                ex = new MetadataTransferException(transfer.getMetadata(), repository, (Throwable)e);
            }
            transfer.setException(ex);
        }
    };
    private static final ExceptionWrapper<ArtifactTransfer> ARTIFACT = new ExceptionWrapper<ArtifactTransfer>(){

        @Override
        public void wrap(ArtifactTransfer transfer, Exception e, RemoteRepository repository) {
            ArtifactNotFoundException ex = null;
            if (e instanceof ResourceDoesNotExistException) {
                ex = new ArtifactNotFoundException(transfer.getArtifact(), repository);
            } else if (e != null) {
                ex = new ArtifactTransferException(transfer.getArtifact(), repository, (Throwable)e);
            }
            transfer.setException(ex);
        }
    };

    public AsyncRepositoryConnector(RemoteRepository repository, RepositorySystemSession session, FileProcessor fileProcessor, Logger logger) throws NoRepositoryConnectorException {
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryConnectorException(repository);
        }
        if (!repository.getProtocol().regionMatches(true, 0, "http", 0, "http".length()) && !repository.getProtocol().regionMatches(true, 0, "dav", 0, "dav".length())) {
            throw new NoRepositoryConnectorException(repository);
        }
        this.logger = logger;
        this.repository = repository;
        this.listener = session.getTransferListener();
        this.fileProcessor = fileProcessor;
        this.session = session;
        this.repoAuthContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository);
        this.proxyAuthContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);
        AsyncHttpClientConfig config = this.createConfig(session, repository, true);
        this.httpClient = new AsyncHttpClient(this.getProvider(session, config), config);
        this.checksumAlgos = new LinkedHashMap<String, String>();
        this.checksumAlgos.put("SHA-1", ".sha1");
        this.checksumAlgos.put("MD5", ".md5");
        this.disableResumeSupport = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{"aether.connector.ahc.disableResumable"});
        this.maxIOExceptionRetry = ConfigUtils.getInteger((RepositorySystemSession)session, (int)3, (String[])new String[]{"aether.connector.ahc.resumeRetry"});
        this.headers = new FluentCaseInsensitiveStringsMap();
        Map headers = ConfigUtils.getMap((RepositorySystemSession)session, null, (String[])new String[]{"aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers"});
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                this.headers.add(entry.getKey().toString(), new String[]{entry.getValue().toString()});
            }
        }
    }

    private AsyncHttpProvider getProvider(RepositorySystemSession session, AsyncHttpClientConfig config) {
        String className = ConfigUtils.getString((RepositorySystemSession)session, (String)"", (String[])new String[]{"aether.connector.ahc.provider"});
        if (className != null && className.length() > 0) {
            if ("netty".equals(className)) {
                className = "com.ning.http.client.providers.netty.NettyAsyncHttpProvider";
            } else if ("jdk".equals(className)) {
                className = "com.ning.http.client.providers.jdk.JDKAsyncHttpProvider";
            } else if ("apache".equals(className)) {
                className = "com.ning.http.client.providers.apache.ApacheAsyncHttpProvider";
            }
            RepositoryCache cache = session.getCache();
            try {
                if (cache == null || cache.get(session, (Object)className) == null) {
                    this.logger.debug("Using AHC provider " + className);
                    Class<?> providerClass = this.getClass().getClassLoader().loadClass(className);
                    Object inst = providerClass.getConstructor(AsyncHttpClientConfig.class).newInstance(config);
                    return (AsyncHttpProvider)inst;
                }
            }
            catch (LinkageError e) {
                this.warn("Could not load AHC provider " + className + ", falling back to default", e);
            }
            catch (ClassNotFoundException e) {
                this.logger.warn("Could not load AHC provider " + className + ", falling back to default");
            }
            catch (ClassCastException e) {
                this.logger.warn("Could not load type-compatible AHC provider " + className + ", falling back to default");
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof InvocationTargetException && e.getCause() != null) {
                    cause = e.getCause();
                }
                this.warn("Could not instantiate AHC provider " + className + ", falling back to default", cause);
            }
            if (cache != null) {
                cache.put(session, (Object)className, (Object)Boolean.TRUE);
            }
        }
        return this.getDefaultProvider(config);
    }

    private AsyncHttpProvider getDefaultProvider(AsyncHttpClientConfig config) {
        return new NettyAsyncHttpProvider(config);
    }

    private void warn(String message, Throwable cause) {
        String msg = message;
        if (cause != null) {
            msg = msg + ": " + cause;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(msg, cause);
        } else {
            this.logger.warn(msg);
        }
    }

    private Realm getRealm(RemoteRepository repository, String credentialEncoding) {
        Realm realm = null;
        if (this.repoAuthContext != null) {
            Realm.RealmBuilder builder = new Realm.RealmBuilder();
            builder.setUsePreemptiveAuth(false).setEnconding(credentialEncoding);
            builder.setPrincipal(this.repoAuthContext.get("username"));
            builder.setPassword(this.repoAuthContext.get("password"));
            realm = builder.build();
        }
        return realm;
    }

    private ProxyServer getProxy(RemoteRepository repository, String credentialEncoding) {
        ProxyServer proxyServer = null;
        Proxy p = repository.getProxy();
        if (p != null) {
            boolean useSSL;
            boolean bl = useSSL = repository.getProtocol().equalsIgnoreCase("https") || repository.getProtocol().equalsIgnoreCase("dav:https");
            if (this.proxyAuthContext == null) {
                proxyServer = new ProxyServer(useSSL ? ProxyServer.Protocol.HTTPS : ProxyServer.Protocol.HTTP, p.getHost(), p.getPort());
            } else {
                proxyServer = new ProxyServer(useSSL ? ProxyServer.Protocol.HTTPS : ProxyServer.Protocol.HTTP, p.getHost(), p.getPort()){

                    public String getPrincipal() {
                        return AsyncRepositoryConnector.this.proxyAuthContext.get("username");
                    }

                    public String getPassword() {
                        return AsyncRepositoryConnector.this.proxyAuthContext.get("password");
                    }

                    public String getNtlmDomain() {
                        return AsyncRepositoryConnector.this.proxyAuthContext.get("ntlm.domain");
                    }
                };
                proxyServer.setEncoding(credentialEncoding);
            }
        }
        return proxyServer;
    }

    private AsyncHttpClientConfig createConfig(RepositorySystemSession session, RemoteRepository repository, boolean useCompression) {
        AsyncHttpClientConfig.Builder configBuilder = new AsyncHttpClientConfig.Builder();
        String userAgent = ConfigUtils.getString((RepositorySystemSession)session, (String)"Aether", (String[])new String[]{"aether.connector.userAgent"});
        if (!StringUtils.isEmpty((String)userAgent)) {
            configBuilder.setUserAgent(userAgent);
        }
        int connectTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)10000, (String[])new String[]{"aether.connector.connectTimeout"});
        String credentialEncoding = ConfigUtils.getString((RepositorySystemSession)session, (String)"ISO-8859-1", (String[])new String[]{"aether.connector.http.credentialEncoding." + repository.getId(), "aether.connector.http.credentialEncoding"});
        configBuilder.setConnectionTimeoutInMs(connectTimeout);
        configBuilder.setCompressionEnabled(useCompression);
        configBuilder.setFollowRedirects(true);
        configBuilder.setMaxRequestRetry(0);
        configBuilder.setRequestTimeoutInMs(ConfigUtils.getInteger((RepositorySystemSession)session, (int)1800000, (String[])new String[]{"aether.connector.requestTimeout"}));
        configBuilder.setProxyServer(this.getProxy(repository, credentialEncoding));
        configBuilder.setRealm(this.getRealm(repository, credentialEncoding));
        return configBuilder.build();
    }

    private void await(CountDownLatch latch) {
        boolean interrupted = false;
        while (latch.getCount() > 0L) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        GetTask task;
        String resource;
        if (this.closed.get()) {
            throw new IllegalStateException("connector closed");
        }
        artifactDownloads = this.safe(artifactDownloads);
        metadataDownloads = this.safe(metadataDownloads);
        CountDownLatch latch = new CountDownLatch(artifactDownloads.size() + metadataDownloads.size());
        ArrayList<GetTask> tasks = new ArrayList<GetTask>();
        for (MetadataDownload metadataDownload : metadataDownloads) {
            resource = this.layout.getPath(metadataDownload.getMetadata()).getPath();
            task = new GetTask(this, resource, metadataDownload.getFile(), metadataDownload.getChecksumPolicy(), latch, (Transfer)metadataDownload, METADATA, false);
            tasks.add(task);
            task.run();
        }
        for (ArtifactDownload artifactDownload : artifactDownloads) {
            resource = this.layout.getPath(artifactDownload.getArtifact()).getPath();
            task = new GetTask(this, resource, artifactDownload.isExistenceCheck() ? null : artifactDownload.getFile(), artifactDownload.getChecksumPolicy(), latch, (Transfer)artifactDownload, ARTIFACT, true);
            tasks.add(task);
            task.run();
        }
        this.await(latch);
        for (GetTask getTask : tasks) {
            getTask.flush();
        }
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        PutTask task;
        String path;
        if (this.closed.get()) {
            throw new IllegalStateException("connector closed");
        }
        artifactUploads = this.safe(artifactUploads);
        metadataUploads = this.safe(metadataUploads);
        CountDownLatch latch = new CountDownLatch(artifactUploads.size() + metadataUploads.size());
        ArrayList<PutTask> tasks = new ArrayList<PutTask>();
        for (ArtifactUpload artifactUpload : artifactUploads) {
            path = this.layout.getPath(artifactUpload.getArtifact()).getPath();
            task = new PutTask(this, path, artifactUpload.getFile(), latch, (Transfer)artifactUpload, ARTIFACT);
            tasks.add(task);
            task.run();
        }
        for (MetadataUpload metadataUpload : metadataUploads) {
            path = this.layout.getPath(metadataUpload.getMetadata()).getPath();
            task = new PutTask(this, path, metadataUpload.getFile(), latch, (Transfer)metadataUpload, METADATA);
            tasks.add(task);
            task.run();
        }
        this.await(latch);
        for (PutTask putTask : tasks) {
            putTask.flush();
        }
    }

    private void handleResponseCode(String url, int responseCode, String responseMsg) throws AuthorizationException, ResourceDoesNotExistException, TransferException {
        if (responseCode == 404) {
            throw new ResourceDoesNotExistException(String.format("Unable to locate resource %s. Error code %s", url, responseCode));
        }
        if (responseCode == 403 || responseCode == 401 || responseCode == 407) {
            throw new AuthorizationException(String.format("Access denied to %s. Error code %s, %s", url, responseCode, responseMsg));
        }
        if (responseCode >= 300) {
            throw new TransferException(String.format("Failed to transfer %s. Error code %s, %s", url, responseCode, responseMsg));
        }
    }

    private TransferEvent newEvent(TransferResource resource, Exception e, TransferEvent.RequestType requestType, TransferEvent.EventType eventType) {
        TransferEvent.Builder event = new TransferEvent.Builder(this.session, resource);
        event.setType(eventType);
        event.setRequestType(requestType);
        event.setException(e);
        return event.build();
    }

    private String buildUrl(String path) {
        String repoUrl = this.repository.getUrl();
        path = path.replace(' ', '+');
        if (repoUrl.charAt(repoUrl.length() - 1) != '/') {
            return repoUrl + '/' + path;
        }
        return repoUrl + path;
    }

    private String validateUri(String path) {
        String tmpUri = this.buildUrl(path);
        String dav = "dav";
        String davHttp = "dav:http";
        if (tmpUri.startsWith(dav)) {
            tmpUri = tmpUri.startsWith(davHttp) ? tmpUri.substring(dav.length() + 1) : "http" + tmpUri.substring(dav.length());
        }
        return tmpUri;
    }

    private boolean resourceExist(String url) throws IOException, ExecutionException, InterruptedException, TransferException, AuthorizationException {
        int statusCode = ((Response)this.httpClient.prepareHead(url).setHeaders(this.headers).execute().get()).getStatusCode();
        switch (statusCode) {
            case 200: {
                return true;
            }
            case 403: {
                throw new AuthorizationException(String.format("Access denied to %s . Status code %s", url, statusCode));
            }
            case 404: {
                return false;
            }
            case 401: {
                throw new AuthorizationException(String.format("Access denied to %s . Status code %s", url, statusCode));
            }
        }
        throw new TransferException("Failed to look for file: " + this.buildUrl(url) + ". Return code is: " + statusCode);
    }

    public void close() {
        this.closed.set(true);
        AuthenticationContext.close((AuthenticationContext)this.repoAuthContext);
        AuthenticationContext.close((AuthenticationContext)this.proxyAuthContext);
        this.httpClient.close();
    }

    private <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockCompanion createOrGetTmpFile(String path, boolean allowResumable) {
        File f;
        File parentFile;
        if (!this.disableResumeSupport && allowResumable && (parentFile = (f = new File(path)).getParentFile()).isDirectory()) {
            for (File tmpFile : parentFile.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.indexOf(".") > 0 && name.lastIndexOf(".") == name.indexOf(".ahc");
                }
            })) {
                if (tmpFile.length() <= 0L) continue;
                String realPath = tmpFile.getPath().substring(0, tmpFile.getPath().lastIndexOf("."));
                FileLockCompanion fileLockCompanion = null;
                if (!realPath.equals(path)) continue;
                File newFile = tmpFile;
                ConcurrentHashMap<RandomAccessFile, Boolean> concurrentHashMap = activeDownloadFiles;
                synchronized (concurrentHashMap) {
                    fileLockCompanion = this.lockFile(tmpFile);
                    this.logger.debug(String.format("Found an incomplete download for file %s.", path));
                    if (fileLockCompanion.getLock() == null) {
                        newFile = this.getTmpFile(path);
                        fileLockCompanion = this.lockFile(newFile);
                    }
                    return fileLockCompanion;
                }
            }
        }
        return new FileLockCompanion(this.getTmpFile(path), null);
    }

    private FileLockCompanion lockFile(File tmpFile) {
        try {
            if (activeDownloadFiles.containsKey(tmpFile)) {
                return new FileLockCompanion(tmpFile, null);
            }
            RandomAccessFile tmpLock = new RandomAccessFile(tmpFile.getPath() + ".lock", "rw");
            FileLock lock = tmpLock.getChannel().tryLock(0L, 1L, false);
            if (lock != null) {
                activeDownloadFiles.put(tmpLock, Boolean.TRUE);
            } else if (lock == null) {
                try {
                    tmpLock.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return new FileLockCompanion(tmpFile, lock, tmpFile.getPath() + ".lock");
        }
        catch (OverlappingFileLockException ex) {
            return new FileLockCompanion(tmpFile, null);
        }
        catch (IOException ex) {
            return new FileLockCompanion(tmpFile, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(FileLockCompanion fileLockCompanion) {
        block5: {
            try {
                if (fileLockCompanion.getLock() == null) break block5;
                try {
                    fileLockCompanion.getLock().channel().close();
                    fileLockCompanion.getLock().release();
                    Object var3_2 = null;
                    if (fileLockCompanion.getLockedPathFile() == null) break block5;
                    new File(fileLockCompanion.getLockedPathFile()).delete();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (fileLockCompanion.getLockedPathFile() != null) {
                        new File(fileLockCompanion.getLockedPathFile()).delete();
                    }
                    throw throwable;
                }
                {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private File getTmpFile(String path) {
        File file;
        while ((file = new File(path + ".ahc" + UUID.randomUUID().toString().replace("-", "").substring(0, 16))).exists()) {
        }
        return file;
    }

    private class LatchGuard {
        private final CountDownLatch latch;
        private final AtomicBoolean done = new AtomicBoolean(false);

        public LatchGuard(CountDownLatch latch) {
            this.latch = latch;
        }

        public void countDown() {
            if (!this.done.getAndSet(true)) {
                this.latch.countDown();
            }
        }
    }

    private static class FileLockCompanion {
        private final File file;
        private final FileLock lock;
        private final String lockPathName;

        public FileLockCompanion(File file, FileLock lock) {
            this.file = file;
            this.lock = lock;
            this.lockPathName = null;
        }

        public FileLockCompanion(File file, FileLock lock, String lockPathName) {
            this.file = file;
            this.lock = lock;
            this.lockPathName = lockPathName;
        }

        public File getFile() {
            return this.file;
        }

        public FileLock getLock() {
            return this.lock;
        }

        public String getLockedPathFile() {
            return this.lockPathName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ExceptionWrapper<T> {
        public void wrap(T var1, Exception var2, RemoteRepository var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PutTask<T extends Transfer>
    implements Runnable {
        private final T upload;
        private final ExceptionWrapper<T> wrapper;
        private final String path;
        private final File file;
        private volatile Exception exception;
        private final LatchGuard latch;
        final /* synthetic */ AsyncRepositoryConnector this$0;

        public PutTask(String path, File file, CountDownLatch latch, T upload, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.file = file;
            this.upload = upload;
            this.wrapper = wrapper;
            this.latch = var1_1.new LatchGuard(latch);
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.upload.setState(Transfer.State.ACTIVE);
            final TransferResource transferResource = new TransferResource(this.this$0.repository.getUrl(), this.path, this.file, this.upload.getTrace());
            try {
                final String uri = this.this$0.validateUri(this.path);
                CompletionHandler completionHandler = new CompletionHandler(transferResource, this.this$0.httpClient, this.this$0.logger, TransferEvent.RequestType.PUT, this.this$0.session){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onThrowable(Throwable t) {
                        try {
                            super.onThrowable(t);
                            if (Exception.class.isAssignableFrom(t.getClass())) {
                                PutTask.this.exception = (Exception)Exception.class.cast(t);
                            } else {
                                PutTask.this.exception = new Exception(t);
                            }
                            if (PutTask.this.this$0.listener != null) {
                                PutTask.this.this$0.listener.transferFailed(PutTask.this.this$0.newEvent(transferResource, PutTask.this.exception, TransferEvent.RequestType.PUT, TransferEvent.EventType.FAILED));
                            }
                            Object var3_2 = null;
                            PutTask.this.latch.countDown();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            PutTask.this.latch.countDown();
                            throw throwable;
                        }
                    }

                    public Response onCompleted(Response r) throws Exception {
                        try {
                            Response response = super.onCompleted(r);
                            PutTask.this.this$0.handleResponseCode(uri, response.getStatusCode(), response.getStatusText());
                            PutTask.this.this$0.httpClient.getConfig().executorService().execute(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        try {
                                            PutTask.this.uploadChecksums(PutTask.this.file, uri);
                                        }
                                        catch (Exception ex) {
                                            PutTask.this.exception = ex;
                                            Object var3_2 = null;
                                            PutTask.this.latch.countDown();
                                        }
                                        Object var3_1 = null;
                                        PutTask.this.latch.countDown();
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_3 = null;
                                        PutTask.this.latch.countDown();
                                        throw throwable;
                                    }
                                }
                            });
                            return r;
                        }
                        catch (Exception ex) {
                            PutTask.this.exception = ex;
                            throw ex;
                        }
                    }
                };
                if (this.this$0.listener != null) {
                    completionHandler.addTransferListener(this.this$0.listener);
                    this.this$0.listener.transferInitiated(this.this$0.newEvent(transferResource, null, TransferEvent.RequestType.PUT, TransferEvent.EventType.INITIATED));
                }
                if (this.file == null) {
                    throw new IllegalArgumentException("no source file specified for upload");
                }
                transferResource.setContentLength(this.file.length());
                ((AsyncHttpClient.BoundRequestBuilder)this.this$0.httpClient.preparePut(uri).setHeaders(this.this$0.headers).setBody((BodyGenerator)new ProgressingFileBodyGenerator(this.file, completionHandler))).execute((AsyncHandler)completionHandler);
            }
            catch (Exception e) {
                try {
                    if (this.this$0.listener != null) {
                        this.this$0.listener.transferFailed(this.this$0.newEvent(transferResource, e, TransferEvent.RequestType.PUT, TransferEvent.EventType.FAILED));
                    }
                    this.exception = e;
                    Object var5_5 = null;
                    this.latch.countDown();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.latch.countDown();
                    throw throwable;
                }
            }
        }

        public void flush() {
            this.wrapper.wrap(this.upload, this.exception, this.this$0.repository);
            this.upload.setState(Transfer.State.DONE);
        }

        private void uploadChecksums(File file, String path) {
            try {
                Map checksums = ChecksumUtils.calc((File)file, this.this$0.checksumAlgos.keySet());
                for (Map.Entry entry : checksums.entrySet()) {
                    this.uploadChecksum(file, path, (String)entry.getKey(), entry.getValue());
                }
            }
            catch (IOException e) {
                this.this$0.logger.debug("Failed to upload checksums for " + file + ": " + e.getMessage(), (Throwable)e);
            }
        }

        private void uploadChecksum(File file, String path, String algo, Object checksum) {
            try {
                if (checksum instanceof Exception) {
                    throw (Exception)checksum;
                }
                String ext = (String)this.this$0.checksumAlgos.get(algo);
                Response response = (Response)this.this$0.httpClient.preparePut(path + ext).setHeaders(this.this$0.headers).setBody(String.valueOf(checksum)).execute().get();
                if (response == null || response.getStatusCode() >= 400) {
                    throw new TransferException(String.format("Checksum failed for %s with status code %s", path + ext, response == null ? 500 : response.getStatusCode()));
                }
            }
            catch (Exception e) {
                String msg = "Failed to upload " + algo + " checksum for " + file + ": " + e.getMessage();
                if (this.this$0.logger.isDebugEnabled()) {
                    this.this$0.logger.warn(msg, (Throwable)e);
                }
                this.this$0.logger.warn(msg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GetTask<T extends Transfer>
    implements Runnable {
        private final T download;
        private final String path;
        private final File file;
        private final String checksumPolicy;
        private final LatchGuard latch;
        private volatile Exception exception;
        private final ExceptionWrapper<T> wrapper;
        private final AtomicBoolean deleteFile = new AtomicBoolean(true);
        private final boolean allowResumable;
        final /* synthetic */ AsyncRepositoryConnector this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public GetTask(String path, File file, String checksumPolicy, CountDownLatch latch, T download, ExceptionWrapper<T> wrapper, boolean allowResumable) {
            this.this$0 = (AsyncRepositoryConnector)n;
            this.path = path;
            this.file = file;
            this.checksumPolicy = checksumPolicy;
            this.allowResumable = allowResumable;
            this.latch = (AsyncRepositoryConnector)n.new LatchGuard(latch);
            this.download = download;
            this.wrapper = wrapper;
        }

        public T getDownload() {
            return this.download;
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                this.download.setState(Transfer.State.ACTIVE);
                final String uri = this.this$0.validateUri(this.path);
                final TransferResource transferResource = new TransferResource(this.this$0.repository.getUrl(), this.path, this.file, this.download.getTrace());
                final TransferEvent.RequestType requestType = this.file != null ? TransferEvent.RequestType.GET : TransferEvent.RequestType.GET_EXISTENCE;
                final boolean ignoreChecksum = "ignore".equals(this.checksumPolicy);
                CompletionHandler completionHandler = null;
                final FileLockCompanion fileLockCompanion = this.file != null ? this.this$0.createOrGetTmpFile(this.file.getPath(), this.allowResumable) : new FileLockCompanion(null, null);
                try {
                    RandomAccessFile resumableFile;
                    long length = 0L;
                    if (fileLockCompanion.getFile() != null) {
                        this.this$0.fileProcessor.mkdirs(fileLockCompanion.getFile().getParentFile());
                    }
                    RandomAccessFile randomAccessFile = resumableFile = fileLockCompanion.getFile() == null ? null : new RandomAccessFile(fileLockCompanion.getFile(), "rw");
                    if (resumableFile != null) {
                        length = resumableFile.length();
                    }
                    FluentCaseInsensitiveStringsMap headers = new FluentCaseInsensitiveStringsMap();
                    if (!this.this$0.useCache) {
                        headers.add("Pragma", new String[]{"no-cache"});
                    }
                    headers.add("Accept", new String[]{"text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2"});
                    headers.replaceAll(this.this$0.headers);
                    Request request = null;
                    final AtomicInteger maxRequestTry = new AtomicInteger();
                    AsyncHttpClient client = this.this$0.httpClient;
                    final AtomicBoolean closeOnComplete = new AtomicBoolean(false);
                    if (length > 0L) {
                        AsyncHttpClientConfig config = this.this$0.createConfig(this.this$0.session, this.this$0.repository, false);
                        client = new AsyncHttpClient((AsyncHttpProvider)new NettyAsyncHttpProvider(config));
                        request = ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(uri).setRangeOffset(length)).setHeaders(headers).build();
                        closeOnComplete.set(true);
                    } else {
                        request = this.this$0.httpClient.prepareGet(uri).setHeaders(headers).build();
                    }
                    final Request activeRequest = request;
                    final AsyncHttpClient activeHttpClient = client;
                    completionHandler = new CompletionHandler(transferResource, this.this$0.httpClient, this.this$0.logger, requestType, this.this$0.session){
                        private final AtomicBoolean handleTmpFile;
                        private final AtomicBoolean localException;
                        {
                            super(x0, x1, x2, x3, x4);
                            this.handleTmpFile = new AtomicBoolean(true);
                            this.localException = new AtomicBoolean(false);
                        }

                        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                            FluentCaseInsensitiveStringsMap h = headers.getHeaders();
                            String rangeByteValue = h.getFirstValue("Content-Range");
                            if (rangeByteValue != null && rangeByteValue.compareToIgnoreCase("none") != 0) {
                                resumableFile.seek(resumableFile.length());
                            } else {
                                resumableFile.seek(0L);
                            }
                            return super.onHeadersReceived(headers);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void onThrowable(Throwable t) {
                            boolean resume = false;
                            try {
                                GetTask.this.this$0.logger.debug("onThrowable", t);
                                try {
                                    if (!GetTask.this.this$0.disableResumeSupport && !this.localException.get() && maxRequestTry.get() < GetTask.this.this$0.maxIOExceptionRetry && GetTask.this.isResumeWorthy(t)) {
                                        GetTask.this.this$0.logger.debug("Trying to recover from an IOException " + activeRequest);
                                        maxRequestTry.incrementAndGet();
                                        Request newRequest = ((RequestBuilder)new RequestBuilder(activeRequest).setRangeOffset(resumableFile.length())).build();
                                        activeHttpClient.executeRequest(newRequest, (AsyncHandler)this);
                                        return;
                                    }
                                }
                                catch (Throwable rt) {
                                    GetTask.this.this$0.logger.warn("Could not resume download", rt);
                                }
                                this.localException.set(false);
                                if (Exception.class.isAssignableFrom(t.getClass())) {
                                    GetTask.this.exception = (Exception)Exception.class.cast(t);
                                } else {
                                    GetTask.this.exception = new Exception(t);
                                }
                                if (closeOnComplete.get()) {
                                    activeHttpClient.close();
                                }
                                super.onThrowable(t);
                                this.fireTransferFailed();
                            }
                            catch (Throwable throwable) {
                                Object var5_9 = null;
                                if (resume) {
                                    return;
                                }
                                if (resumableFile != null) {
                                    try {
                                        resumableFile.close();
                                    }
                                    catch (IOException ex2) {
                                        // empty catch block
                                    }
                                }
                                GetTask.this.deleteFile(fileLockCompanion);
                                GetTask.this.latch.countDown();
                                this.removeListeners();
                                throw throwable;
                            }
                            Object var5_7 = null;
                            if (resume) {
                                return;
                            }
                            if (resumableFile != null) {
                                try {
                                    resumableFile.close();
                                }
                                catch (IOException ex2) {
                                    // empty catch block
                                }
                            }
                            GetTask.this.deleteFile(fileLockCompanion);
                            GetTask.this.latch.countDown();
                            this.removeListeners();
                            {
                                return;
                                catch (Throwable ex) {
                                    GetTask.this.this$0.logger.warn("Unexpected exception", ex);
                                    Object var5_8 = null;
                                    if (resume) {
                                        return;
                                    }
                                    if (resumableFile != null) {
                                        try {
                                            resumableFile.close();
                                        }
                                        catch (IOException ex2) {
                                            // empty catch block
                                        }
                                    }
                                    GetTask.this.deleteFile(fileLockCompanion);
                                    GetTask.this.latch.countDown();
                                    this.removeListeners();
                                    return;
                                }
                            }
                        }

                        private void removeListeners() {
                            this.removeTransferListener(GetTask.this.this$0.listener);
                        }

                        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                            if (this.status() != null && (this.status().getStatusCode() == 200 || this.status().getStatusCode() == 206)) {
                                byte[] bytes = content.getBodyPartBytes();
                                try {
                                    resumableFile.write(bytes);
                                }
                                catch (IOException ex) {
                                    GetTask.this.this$0.logger.debug("onBodyPartReceived", (Throwable)ex);
                                    GetTask.this.exception = ex;
                                    this.localException.set(true);
                                    throw ex;
                                }
                            }
                            return super.onBodyPartReceived(content);
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public Response onCompleted(Response r) throws Exception {
                            Response response2;
                            try {
                                try {
                                    GetTask.this.deleteFile.set(true);
                                    try {
                                        resumableFile.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                    Response response = super.onCompleted(r);
                                    GetTask.this.this$0.handleResponseCode(uri, response.getStatusCode(), response.getStatusText());
                                    if (!ignoreChecksum) {
                                        activeHttpClient.getConfig().executorService().execute(new Runnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Loose catch block
                                             */
                                            public void run() {
                                                block22: {
                                                    try {
                                                        block21: {
                                                            try {
                                                                Map checksums = ChecksumUtils.calc((File)fileLockCompanion.getFile(), GetTask.this.this$0.checksumAlgos.keySet());
                                                                if (!GetTask.this.verifyChecksum(GetTask.this.file, uri, (String)checksums.get("SHA-1"), ".sha1") && !GetTask.this.verifyChecksum(GetTask.this.file, uri, (String)checksums.get("MD5"), ".md5")) {
                                                                    throw new ChecksumFailureException("Checksum validation failed, no checksums available from the repository");
                                                                }
                                                            }
                                                            catch (ChecksumFailureException e) {
                                                                if ("fail".equals(GetTask.this.checksumPolicy)) {
                                                                    throw e;
                                                                }
                                                                if (GetTask.this.this$0.listener == null) break block21;
                                                                GetTask.this.this$0.listener.transferCorrupted(GetTask.this.this$0.newEvent(transferResource, (Exception)((Object)e), requestType, TransferEvent.EventType.CORRUPTED));
                                                            }
                                                        }
                                                        Object var3_4 = null;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var3_6 = null;
                                                        if (GetTask.this.exception == null) {
                                                            try {
                                                                GetTask.this.rename(fileLockCompanion.getFile(), GetTask.this.file);
                                                                GetTask.this.this$0.releaseLock(fileLockCompanion);
                                                            }
                                                            catch (IOException e) {
                                                                GetTask.this.exception = e;
                                                            }
                                                        } else {
                                                            GetTask.this.deleteFile(fileLockCompanion);
                                                        }
                                                        GetTask.this.latch.countDown();
                                                        if (closeOnComplete.get()) {
                                                            activeHttpClient.close();
                                                        }
                                                        throw throwable;
                                                    }
                                                    if (GetTask.this.exception == null) {
                                                        try {
                                                            GetTask.this.rename(fileLockCompanion.getFile(), GetTask.this.file);
                                                            GetTask.this.this$0.releaseLock(fileLockCompanion);
                                                        }
                                                        catch (IOException e) {
                                                            GetTask.this.exception = e;
                                                        }
                                                    } else {
                                                        GetTask.this.deleteFile(fileLockCompanion);
                                                    }
                                                    GetTask.this.latch.countDown();
                                                    if (closeOnComplete.get()) {
                                                        activeHttpClient.close();
                                                    }
                                                    break block22;
                                                    {
                                                        catch (Exception ex) {
                                                            GetTask.this.exception = ex;
                                                            Object var3_5 = null;
                                                            if (GetTask.this.exception == null) {
                                                                try {
                                                                    GetTask.this.rename(fileLockCompanion.getFile(), GetTask.this.file);
                                                                    GetTask.this.this$0.releaseLock(fileLockCompanion);
                                                                }
                                                                catch (IOException e) {
                                                                    GetTask.this.exception = e;
                                                                }
                                                            } else {
                                                                GetTask.this.deleteFile(fileLockCompanion);
                                                            }
                                                            GetTask.this.latch.countDown();
                                                            if (closeOnComplete.get()) {
                                                                activeHttpClient.close();
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        });
                                    } else {
                                        GetTask.this.rename(fileLockCompanion.getFile(), GetTask.this.file);
                                        GetTask.this.this$0.releaseLock(fileLockCompanion);
                                        this.handleTmpFile.set(false);
                                        GetTask.this.latch.countDown();
                                        if (closeOnComplete.get()) {
                                            activeHttpClient.close();
                                        }
                                    }
                                    this.removeListeners();
                                    response2 = response;
                                    Object var5_6 = null;
                                }
                                catch (Exception ex) {
                                    GetTask.this.exception = ex;
                                    this.localException.set(true);
                                    throw ex;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_7 = null;
                                try {
                                    if (!this.handleTmpFile.get()) throw throwable;
                                    if (fileLockCompanion.getFile() == null) throw throwable;
                                    if (GetTask.this.exception != null) {
                                        GetTask.this.deleteFile(fileLockCompanion);
                                        throw throwable;
                                    }
                                    if (!ignoreChecksum) throw throwable;
                                    GetTask.this.rename(fileLockCompanion.getFile(), GetTask.this.file);
                                    GetTask.this.this$0.releaseLock(fileLockCompanion);
                                    throw throwable;
                                }
                                catch (IOException ex2) {
                                    GetTask.this.exception = ex2;
                                    throw throwable;
                                }
                            }
                            try {}
                            catch (IOException ex2) {
                                GetTask.this.exception = ex2;
                                return response2;
                            }
                            if (!this.handleTmpFile.get()) return response2;
                            if (fileLockCompanion.getFile() == null) return response2;
                            if (GetTask.this.exception != null) {
                                GetTask.this.deleteFile(fileLockCompanion);
                                return response2;
                            }
                            if (!ignoreChecksum) return response2;
                            GetTask.this.rename(fileLockCompanion.getFile(), GetTask.this.file);
                            GetTask.this.this$0.releaseLock(fileLockCompanion);
                            return response2;
                        }
                    };
                    try {
                        if (this.file == null) {
                            if (!this.this$0.resourceExist(uri)) {
                                throw new ResourceDoesNotExistException("Could not find " + uri + " in " + this.this$0.repository.getUrl());
                            }
                            this.latch.countDown();
                            break block18;
                        }
                        if (this.this$0.listener != null) {
                            completionHandler.addTransferListener(this.this$0.listener);
                            this.this$0.listener.transferInitiated(this.this$0.newEvent(transferResource, null, requestType, TransferEvent.EventType.INITIATED));
                        }
                        activeHttpClient.executeRequest(request, (AsyncHandler)completionHandler);
                    }
                    catch (Exception ex) {
                        try {
                            if (resumableFile != null) {
                                resumableFile.close();
                            }
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        this.deleteFile(fileLockCompanion);
                        this.exception = ex;
                        this.latch.countDown();
                    }
                }
                catch (Throwable t) {
                    this.deleteFile(fileLockCompanion);
                    try {
                        this.exception = Exception.class.isAssignableFrom(t.getClass()) ? (Exception)Exception.class.cast(t) : new Exception(t);
                        if (this.this$0.listener != null) {
                            this.this$0.listener.transferFailed(this.this$0.newEvent(transferResource, this.exception, requestType, TransferEvent.EventType.FAILED));
                        }
                        Object var20_19 = null;
                        this.latch.countDown();
                    }
                    catch (Throwable throwable) {
                        Object var20_20 = null;
                        this.latch.countDown();
                        throw throwable;
                    }
                }
            }
        }

        private boolean isResumeWorthy(Throwable t) {
            if (t instanceof IOException) {
                return !(t instanceof ConnectException);
            }
            return false;
        }

        private void deleteFile(FileLockCompanion fileLockCompanion) {
            if (fileLockCompanion.getFile() != null && this.deleteFile.get()) {
                this.this$0.releaseLock(fileLockCompanion);
                activeDownloadFiles.remove(fileLockCompanion.getFile());
                fileLockCompanion.getFile().delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean verifyChecksum(File file, String path, String actual, String ext) throws ChecksumFailureException {
            File tmp = this.this$0.getTmpFile(file.getPath() + ext);
            try {
                String expected;
                Response response;
                block12: {
                    response = (Response)this.this$0.httpClient.prepareGet(path + ext).setHeaders(this.this$0.headers).execute().get();
                    if (response.getStatusCode() != 404) break block12;
                    boolean bl = false;
                    Object var14_12 = null;
                    tmp.delete();
                    return bl;
                }
                try {
                    BufferedOutputStream fs = new BufferedOutputStream(new FileOutputStream(tmp));
                    try {
                        InputStream is = response.getResponseBodyAsStream();
                        byte[] buffer = new byte[4096];
                        int n = 0;
                        while (-1 != (n = is.read(buffer))) {
                            ((OutputStream)fs).write(buffer, 0, n);
                        }
                        ((OutputStream)fs).flush();
                        Object var12_18 = null;
                        ((OutputStream)fs).close();
                    }
                    catch (Throwable throwable) {
                        Object var12_19 = null;
                        ((OutputStream)fs).close();
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    throw new ChecksumFailureException((Throwable)ex);
                }
                try {
                    expected = ChecksumUtils.read((File)tmp);
                }
                catch (IOException e) {
                    throw new ChecksumFailureException((Throwable)e);
                }
                if (!expected.equalsIgnoreCase(actual)) throw new ChecksumFailureException(expected, actual);
                try {
                    this.rename(tmp, new File(file.getPath() + ext));
                }
                catch (IOException e) {}
                Object var14_13 = null;
                tmp.delete();
                return true;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                tmp.delete();
                throw throwable;
            }
        }

        public void flush() {
            this.wrapper.wrap(this.download, this.exception, this.this$0.repository);
            this.download.setState(Transfer.State.DONE);
        }

        private void rename(File from, File to) throws IOException {
            this.this$0.fileProcessor.move(from, to);
        }
    }
}

