/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.VerboseDescription;
import org.dspace.sword2.WorkflowManager;
import org.dspace.sword2.WorkflowTools;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordError;
import org.swordapp.server.UriRegistry;

public class WorkflowManagerUnrestricted
implements WorkflowManager {
    public void retrieveServiceDoc(Context context) throws SwordError {
    }

    public void listCollectionContents(Context context, Collection collection) throws SwordError {
    }

    public void createResource(Context context, Collection collection) throws SwordError {
    }

    public void retrieveContent(Context context, Item item) throws SwordError {
    }

    public void retrieveBitstream(Context context, Bitstream bitstream) throws SwordError, DSpaceSwordException {
    }

    public void replaceResourceContent(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void replaceMetadata(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void replaceMetadataAndMediaResource(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void deleteMediaResource(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void deleteBitstream(Context context, Bitstream bitstream) throws SwordError, DSpaceSwordException {
        try {
            List bundles = bitstream.getBundles();
            for (Bundle bundle : bundles) {
                if (!"ORIGINAL".equals(bundle.getName())) {
                    throw new SwordError(UriRegistry.ERROR_METHOD_NOT_ALLOWED, "The file is not in a bundle which can be modified");
                }
                List items = bundle.getItems();
                for (Item item : items) {
                    this.deleteMediaResource(context, item);
                }
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public void replaceBitstream(Context context, Bitstream bitstream) throws SwordError, DSpaceSwordException {
        try {
            List bundles = bitstream.getBundles();
            for (Bundle bundle : bundles) {
                if (!"ORIGINAL".equals(bundle.getName())) {
                    throw new SwordError(UriRegistry.ERROR_METHOD_NOT_ALLOWED, "The file is not in a bundle which can be modified");
                }
                List items = bundle.getItems();
                for (Item item : items) {
                    this.replaceResourceContent(context, item);
                }
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public void addResourceContent(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void addMetadata(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void deleteItem(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void retrieveStatement(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void modifyState(Context context, Item item) throws SwordError, DSpaceSwordException {
    }

    public void resolveState(Context context, Deposit deposit, DepositResult result, VerboseDescription verboseDescription) throws DSpaceSwordException {
        this.resolveState(context, deposit, result, verboseDescription, true);
    }

    public void resolveState(Context context, Deposit deposit, DepositResult result, VerboseDescription verboseDescription, boolean containerOperation) throws DSpaceSwordException {
        boolean inarch;
        if (!containerOperation) {
            return;
        }
        Item item = result.getItem();
        WorkflowTools wft = new WorkflowTools();
        boolean inwf = wft.isItemInWorkflow(context, item);
        boolean inws = wft.isItemInWorkspace(context, item);
        boolean bl = inarch = item.isArchived() || item.isWithdrawn();
        if (!deposit.isInProgress() && inarch) {
            verboseDescription.append("The deposit is finished, and the item is already in the archive");
        }
        if (!deposit.isInProgress() && inws) {
            verboseDescription.append("The deposit is finished: moving it from the workspace to the workflow");
            wft.startWorkflow(context, item);
        }
        if (deposit.isInProgress() && inarch) {
            verboseDescription.append("The deposit is not finished, and the item is already in the archive");
        }
        if (deposit.isInProgress() && inwf) {
            verboseDescription.append("The deposit is in progress, but is in the workflow; returning to the workspace");
            wft.stopWorkflow(context, item);
        }
    }
}

