/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordContentIngester;
import org.dspace.sword2.SwordEntryIngester;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordError;
import org.swordapp.server.UriRegistry;

public class SwordIngesterFactory {
    public static SwordContentIngester getContentInstance(Context context, Deposit deposit, DSpaceObject dso) throws DSpaceSwordException, SwordError {
        SwordContentIngester ingester = null;
        PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();
        ingester = (SwordContentIngester)pluginService.getNamedPlugin(SwordContentIngester.class, deposit.getMimeType());
        if (ingester != null) {
            return ingester;
        }
        ingester = (SwordContentIngester)pluginService.getNamedPlugin(SwordContentIngester.class, deposit.getPackaging());
        if (ingester == null) {
            throw new SwordError(UriRegistry.ERROR_CONTENT, "No ingester configured for this package type");
        }
        return ingester;
    }

    public static SwordEntryIngester getEntryInstance(Context context, Deposit deposit, DSpaceObject dso) throws DSpaceSwordException, SwordError {
        SwordEntryIngester ingester = (SwordEntryIngester)CoreServiceFactory.getInstance().getPluginService().getSinglePlugin(SwordEntryIngester.class);
        if (ingester == null) {
            throw new SwordError(UriRegistry.ERROR_CONTENT, "No ingester configured for handling sword entry documents");
        }
        return ingester;
    }
}

