/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class VersionManager {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    public void removeBundle(Context context, Item item, String name) throws SQLException, AuthorizeException, IOException {
        boolean keep = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"versions.keep");
        Iterator bundles = item.getBundles().iterator();
        while (bundles.hasNext()) {
            Bundle b = (Bundle)bundles.next();
            if (!name.equals(b.getName())) continue;
            bundles.remove();
            this.removeBundle(context, item, b, keep);
        }
    }

    public void removeBundle(Context context, Item item, Bundle source) throws SQLException, AuthorizeException, IOException {
        boolean keep = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"versions.keep");
        this.removeBundle(context, item, source, keep);
    }

    public void removeBundle(Context context, Item item, Bundle source, boolean archive) throws SQLException, AuthorizeException, IOException {
        if (archive) {
            this.archiveBundle(context, item, source);
        }
        Iterator bitstreams = source.getBitstreams().iterator();
        while (bitstreams.hasNext()) {
            Bitstream bitstream = (Bitstream)bitstreams.next();
            bitstreams.remove();
            this.bundleService.removeBitstream(context, source, bitstream);
        }
        this.itemService.removeBundle(context, item, source);
    }

    public void removeBitstream(Context context, Item item, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        boolean keep = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"versions.keep");
        this.removeBitstream(context, item, bitstream, keep);
    }

    public void removeBitstream(Context context, Item item, Bitstream bitstream, boolean keep) throws SQLException, AuthorizeException, IOException {
        Bundle exempt = null;
        if (keep) {
            exempt = this.archiveBitstream(context, item, bitstream);
        }
        Iterator bundles = bitstream.getBundles().iterator();
        while (bundles.hasNext()) {
            Bundle bundle = (Bundle)bundles.next();
            if (exempt == null || bundle.getID() == exempt.getID()) continue;
            bundles.remove();
            this.bundleService.removeBitstream(context, bundle, bitstream);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String desc = bitstream.getDescription();
        String newDesc = "[Deleted on: " + sdf.format(new Date()) + "] ";
        if (desc != null) {
            newDesc = newDesc + desc;
        }
        bitstream.setDescription(context, newDesc);
        this.bitstreamService.update(context, (DSpaceObject)bitstream);
    }

    private Bundle archiveBitstream(Context context, Item item, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        String swordBundle = ConfigurationManager.getProperty((String)"swordv2-server", (String)"bundle.deleted");
        if (swordBundle == null) {
            swordBundle = "DELETED";
        }
        List bundles = item.getBundles();
        Bundle archive = null;
        for (Bundle bundle : bundles) {
            if (!swordBundle.equals(bundle.getName())) continue;
            archive = bundle;
            break;
        }
        if (archive == null) {
            archive = this.bundleService.create(context, item, swordBundle);
        }
        this.archiveBitstream(context, archive, bitstream);
        return archive;
    }

    private void archiveBitstream(Context context, Bundle target, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        this.bundleService.addBitstream(context, target, bitstream);
    }

    private void archiveBundle(Context context, Item item, Bundle source) throws SQLException, AuthorizeException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String oldName = "VER" + sdf.format(new Date());
        oldName = this.getNumberedName(item, oldName, 0);
        Bundle old = this.bundleService.create(context, item, oldName);
        List bitstreams = source.getBitstreams();
        for (Bitstream bitstream : bitstreams) {
            this.bundleService.addBitstream(context, old, bitstream);
        }
    }

    private String getNumberedName(Item item, String name, int number) throws SQLException {
        String nName = name + "." + Integer.toString(number);
        List bundles = item.getBundles();
        for (Bundle bundle : bundles) {
            if (!nName.equals(bundle.getName())) continue;
            return this.getNumberedName(item, name, number + 1);
        }
        return nName;
    }
}

