/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.List;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.GenericStatementDisseminator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordStatementDisseminator;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.AtomStatement;
import org.swordapp.server.Statement;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class AtomStatementDisseminator
extends GenericStatementDisseminator
implements SwordStatementDisseminator {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public Statement disseminate(Context context, Item item) throws DSpaceSwordException, SwordError, SwordServerException {
        SwordUrlManager urlManager = new SwordUrlManager(new SwordConfigurationDSpace(), context);
        String feedUri = urlManager.getAtomStatementUri(item);
        String authorField = ConfigurationManager.getProperty((String)"swordv2-server", (String)"author.field");
        String titleField = ConfigurationManager.getProperty((String)"swordv2-server", (String)"title.field");
        String updatedField = ConfigurationManager.getProperty((String)"swordv2-server", (String)"updated.field");
        String author = this.stringMetadata(item, authorField);
        String title = this.stringMetadata(item, titleField);
        String updated = this.stringMetadata(item, updatedField);
        AtomStatement s = new AtomStatement(feedUri, author, title, updated);
        this.populateStatement(context, item, (Statement)s);
        return s;
    }

    private String stringMetadata(Item item, String field) {
        if (field == null) {
            return null;
        }
        List dcvs = this.itemService.getMetadataByMetadataString((DSpaceObject)item, field);
        if (dcvs == null || dcvs.isEmpty()) {
            return null;
        }
        StringBuilder md = new StringBuilder();
        for (MetadataValue dcv : dcvs) {
            if (md.length() > 0) {
                md.append(", ");
            }
            md.append(dcv.getValue());
        }
        return md.toString();
    }
}

