/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.swordapp.server.UriRegistry;

public class SwordEntry {
    public Entry entry;

    public SwordEntry(Entry entry) {
        this.entry = entry;
    }

    public String getTitle() {
        return this.entry.getTitle();
    }

    public String getSummary() {
        return this.entry.getSummary();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.entry.writeTo((OutputStream)baos);
            return baos.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, List<String>> getDublinCore() {
        HashMap<String, List<String>> dc = new HashMap<String, List<String>>();
        List extensions = this.entry.getExtensions();
        for (Element element : extensions) {
            if (!UriRegistry.DC_NAMESPACE.equals(element.getQName().getNamespaceURI())) continue;
            String field = element.getQName().getLocalPart();
            String value = element.getText();
            if (dc.containsKey(field)) {
                ((List)dc.get(field)).add(value);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            dc.put(field, values);
        }
        return dc;
    }
}

