/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import org.apache.abdera.Abdera;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Workspace;
import org.swordapp.server.SwordWorkspace;
import org.swordapp.server.UriRegistry;

public class ServiceDocument {
    private String version = "2.0";
    private int maxUploadSize = -1;
    private Service service;

    public ServiceDocument() {
        Abdera abdera = new Abdera();
        this.service = abdera.newService();
    }

    public Service getWrappedService() {
        return this.service;
    }

    public Service getAbderaService() {
        Service abderaService = (Service)this.service.clone();
        abderaService.addSimpleExtension(UriRegistry.SWORD_VERSION, this.version);
        if (this.maxUploadSize > -1) {
            abderaService.addSimpleExtension(UriRegistry.SWORD_MAX_UPLOAD_SIZE, Integer.toString(this.maxUploadSize));
        }
        return abderaService;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public void addWorkspace(SwordWorkspace workspace) {
        Workspace abderaWorkspace = workspace.getAbderaWorkspace();
        this.service.addWorkspace(abderaWorkspace);
    }
}

