/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.File;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.handle.HandleManager;
import org.dspace.sword2.AbstractSwordContentIngester;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class SwordMETSContentIngester
extends AbstractSwordContentIngester {
    public static final Logger log = Logger.getLogger(SwordMETSContentIngester.class);

    public DepositResult ingest(Context context, Deposit deposit, DSpaceObject dso, VerboseDescription verboseDescription) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        return this.ingest(context, deposit, dso, verboseDescription, null);
    }

    public DepositResult ingestToCollection(Context context, Deposit deposit, Collection collection, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            if (result != null) {
                Item item = result.getItem();
                return this.ingestToItem(context, deposit, item, verboseDescription, result);
            }
            WorkspaceItem wsi = WorkspaceItem.create((Context)context, (Collection)collection, (boolean)true);
            Item item = wsi.getItem();
            String licence = collection.getLicense();
            if (PackageUtils.findDepositLicense((Context)context, (Item)item) == null) {
                PackageUtils.addDepositLicense((Context)context, (String)licence, (Item)item, (Collection)collection);
            }
            File depositFile = deposit.getFile();
            String cfg = ConfigurationManager.getProperty((String)"sword-server", (String)"mets-ingester.package-ingester");
            if (cfg == null || "".equals(cfg)) {
                cfg = "METS";
            }
            verboseDescription.append("Using package manifest format: " + cfg);
            PackageIngester pi = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, (String)cfg);
            verboseDescription.append("Loaded package ingester: " + pi.getClass().getName());
            PackageParameters params = new PackageParameters();
            params.setWorkflowEnabled(true);
            if (ConfigurationManager.getBooleanProperty((String)"sword-server", (String)"restore-mode.enable", (boolean)false)) {
                params.setRestoreModeEnabled(true);
            }
            params.setUseCollectionTemplate(ConfigurationManager.getBooleanProperty((String)"mets.default.ingest.useCollectionTemplate", (boolean)false));
            DSpaceObject ingestedObject = pi.replace(context, (DSpaceObject)item, depositFile, params);
            if (ingestedObject == null) {
                verboseDescription.append("Failed to ingest the package; throwing exception");
                throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/UnpackageFail", "METS package ingester failed to unpack package");
            }
            if (!(ingestedObject instanceof Item)) {
                throw new DSpaceSwordException("DSpace Ingester returned wrong object type -- not an Item result.");
            }
            verboseDescription.append("Workflow process started");
            Item installedItem = (Item)ingestedObject;
            this.setUpdatedDate(installedItem, verboseDescription);
            this.setSlug(installedItem, deposit.getSlug(), verboseDescription);
            boolean ignore = context.ignoreAuthorization();
            context.setIgnoreAuthorization(true);
            installedItem.update();
            context.setIgnoreAuthorization(ignore);
            String handle = HandleManager.findHandle((Context)context, (DSpaceObject)installedItem);
            verboseDescription.append("Ingest successful");
            verboseDescription.append("Item created with internal identifier: " + installedItem.getID());
            if (handle != null) {
                verboseDescription.append("Item created with external identifier: " + handle);
            } else {
                verboseDescription.append("No external identifier available at this stage (item in workflow)");
            }
            DepositResult dr = new DepositResult();
            dr.setItem(installedItem);
            dr.setTreatment(this.getTreatment());
            return dr;
        }
        catch (RuntimeException re) {
            log.error((Object)"caught exception: ", (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public DepositResult ingestToItem(Context context, Deposit deposit, Item item, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        if (result == null) {
            result = new DepositResult();
        }
        try {
            File depositFile = deposit.getFile();
            String cfg = ConfigurationManager.getProperty((String)"sword-server", (String)"mets-ingester.package-ingester");
            if (cfg == null || "".equals(cfg)) {
                cfg = "METS";
            }
            verboseDescription.append("Using package manifest format: " + cfg);
            PackageIngester pi = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, (String)cfg);
            verboseDescription.append("Loaded package ingester: " + pi.getClass().getName());
            PackageParameters params = new PackageParameters();
            params.setWorkflowEnabled(true);
            if (ConfigurationManager.getBooleanProperty((String)"sword-server", (String)"restore-mode.enable", (boolean)false)) {
                params.setRestoreModeEnabled(true);
            }
            params.setUseCollectionTemplate(ConfigurationManager.getBooleanProperty((String)"mets.default.ingest.useCollectionTemplate", (boolean)false));
            DSpaceObject ingestedObject = pi.replace(context, (DSpaceObject)item, depositFile, params);
            if (ingestedObject == null) {
                verboseDescription.append("Failed to replace the package; throwing exception");
                throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/UnpackageFail", "METS package ingester failed to unpack package");
            }
            if (!(ingestedObject instanceof Item)) {
                throw new DSpaceSwordException("DSpace Ingester returned wrong object type -- not an Item result.");
            }
            Item installedItem = (Item)ingestedObject;
            this.setUpdatedDate(installedItem, verboseDescription);
            boolean ignore = context.ignoreAuthorization();
            context.setIgnoreAuthorization(true);
            installedItem.update();
            context.setIgnoreAuthorization(ignore);
            String handle = HandleManager.findHandle((Context)context, (DSpaceObject)installedItem);
            verboseDescription.append("Replace successful");
            result.setItem(installedItem);
            result.setTreatment(this.getTreatment());
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"caught exception: ", (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private String getTreatment() throws DSpaceSwordException {
        return "The package has been deposited into DSpace.  Each file has been unpacked and provided with a unique identifier.  The metadata in the manifest has been extracted and attached to the DSpace item, which has been provided with an identifier leading to an HTML splash page.";
    }
}

