/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.step.SherpaPolicy;
import org.dspace.app.rest.submit.AbstractProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.sherpa.cache.SherpaCacheEvictService;
import org.dspace.app.sherpa.submit.SHERPASubmitService;
import org.dspace.app.sherpa.v2.SHERPAResponse;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.InProgressSubmission;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.web.ContextUtil;

public class SherpaPolicyStep
extends AbstractProcessingStep {
    public static final String SHERPA_RETRIEVAL_TIME = "retrievalTime";
    private SherpaCacheEvictService sherpaCacheEvictService = (SherpaCacheEvictService)new DSpace().getSingletonService(SherpaCacheEvictService.class);
    private SHERPASubmitService sherpaSubmitService = (SHERPASubmitService)new DSpace().getSingletonService(SHERPASubmitService.class);

    public SherpaPolicy getData(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws Exception {
        Context context = ContextUtil.obtainCurrentRequestContext();
        SHERPAResponse response = this.sherpaSubmitService.searchRelatedJournals(context, obj.getItem());
        if (Objects.nonNull(response)) {
            SherpaPolicy result = new SherpaPolicy();
            result.setSherpaResponse(response);
            return result;
        }
        return null;
    }

    @Override
    public void doPatchProcessing(Context context, HttpServletRequest currentRequest, InProgressSubmission source, Operation op, SubmissionStepConfig stepConf) throws Exception {
        String path = op.getPath();
        if (path.contains(SHERPA_RETRIEVAL_TIME)) {
            this.sherpaCacheEvictService.evictCacheValues(context, source.getItem());
        }
    }
}

