/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.step.DataDuplicateDetection;
import org.dspace.app.rest.submit.AbstractProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;

public class DuplicateDetectionStep
extends AbstractProcessingStep {
    private static final Logger log = LogManager.getLogger(DuplicateDetectionStep.class);
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;

    public DataDuplicateDetection getData(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException("Null in-progress wrapper object");
        }
        if (obj.getItem() == null) {
            throw new IllegalArgumentException("Null in-progress item");
        }
        if (!this.configurationService.getBooleanProperty("duplicate.enable", false)) {
            log.debug("Duplicate detection is not enabled, returning empty section");
            return new DataDuplicateDetection();
        }
        Context context = this.getContext();
        if (context == null) {
            throw new ServletException("Null context");
        }
        return submissionService.getDataDuplicateDetection(context, obj);
    }

    private Context getContext() {
        Context context;
        Request currentRequest = DSpaceServicesFactory.getInstance().getRequestService().getCurrentRequest();
        if (currentRequest != null) {
            HttpServletRequest request = currentRequest.getHttpServletRequest();
            context = ContextUtil.obtainContext(request);
        } else {
            context = new Context();
        }
        return context;
    }

    @Override
    public void doPatchProcessing(Context context, HttpServletRequest currentRequest, InProgressSubmission source, Operation op, SubmissionStepConfig stepConf) throws Exception {
        log.warn("Not implemented");
    }
}

