/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class DSpace401AuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private RestAuthenticationService restAuthenticationService;

    public DSpace401AuthenticationEntryPoint(RestAuthenticationService restAuthenticationService) {
        this.restAuthenticationService = restAuthenticationService;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        response.setHeader("WWW-Authenticate", this.restAuthenticationService.getWwwAuthenticateHeaderValue(request, response));
        response.sendError(401, "Authentication is required");
    }
}

