/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.NotifyServiceInboundPattern;
import org.dspace.app.ldn.service.NotifyServiceInboundPatternService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.ldn.NotifyServicePatchUtils;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyServiceInboundPatternsReplaceOperation
extends PatchOperation<NotifyServiceEntity> {
    @Autowired
    private NotifyServiceInboundPatternService inboundPatternService;
    @Autowired
    private NotifyServicePatchUtils notifyServicePatchUtils;
    private static final String OPERATION_PATH = "notifyServiceInboundPatterns";

    @Override
    public NotifyServiceEntity perform(Context context, NotifyServiceEntity notifyServiceEntity, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(notifyServiceEntity, operation)) {
            try {
                List<NotifyServiceInboundPattern> patchInboundPatterns = this.notifyServicePatchUtils.extractNotifyServiceInboundPatternsFromOperation(operation);
                notifyServiceEntity.getInboundPatterns().forEach(inboundPattern -> {
                    try {
                        this.inboundPatternService.delete(context, inboundPattern);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
                for (NotifyServiceInboundPattern patchInboundPattern : patchInboundPatterns) {
                    NotifyServiceInboundPattern inboundPattern2 = this.inboundPatternService.create(context, notifyServiceEntity);
                    inboundPattern2.setPattern(patchInboundPattern.getPattern());
                    inboundPattern2.setConstraint(patchInboundPattern.getConstraint());
                    inboundPattern2.setAutomatic(patchInboundPattern.isAutomatic());
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return notifyServiceEntity;
        }
        throw new DSpaceBadRequestException("NotifyServiceInboundPatternsReplaceOperation does not support this operation");
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof NotifyServiceEntity && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PATH);
    }
}

