/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.PasswordNotValidException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.exception.WrongCurrentPasswordException;
import org.dspace.app.rest.model.patch.JsonValueEvaluator;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.ValidatePasswordService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component
public class EPersonPasswordAddOperation<R>
extends PatchOperation<R> {
    private static final Logger log = LogManager.getLogger(EPersonPasswordAddOperation.class);
    public static final String OPERATION_PASSWORD_CHANGE = "/password";
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    @Autowired
    private RequestService requestService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private ValidatePasswordService validatePasswordService;
    @Autowired
    private AuthenticationService authenticationService;

    @Override
    public R perform(Context context, R object, Operation operation) {
        if (!this.supports(object, operation)) {
            throw new DSpaceBadRequestException(this.getClass().getName() + " does not support this operation");
        }
        PasswordVO passwordVO = this.parseOperationValue(operation);
        String newPassword = passwordVO.getNewPassword().orElseThrow(() -> new DSpaceBadRequestException("No password provided"));
        EPerson eperson = (EPerson)object;
        if (!AuthorizeUtil.authorizeUpdatePassword((Context)context, (String)eperson.getEmail())) {
            throw new DSpaceBadRequestException("Password cannot be updated for the given EPerson with email: " + eperson.getEmail());
        }
        if (!this.validatePasswordService.isPasswordValid(newPassword)) {
            throw new PasswordNotValidException();
        }
        String token = this.requestService.getCurrentRequest().getHttpServletRequest().getParameter("token");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.verifyAndDeleteToken(context, eperson, token, operation);
        } else if (eperson.hasPasswordSet()) {
            this.verifyCurrentPassword(context, eperson, passwordVO);
        }
        this.ePersonService.setPassword(eperson, newPassword);
        return object;
    }

    private PasswordVO parseOperationValue(Operation operation) {
        if (operation.getValue() == null) {
            throw new UnprocessableEntityException("No value provided for operation " + operation.getPath());
        }
        try {
            return (PasswordVO)((JsonValueEvaluator)operation.getValue()).evaluate(PasswordVO.class);
        }
        catch (Exception ex) {
            throw new UnprocessableEntityException("Invalid value provided for operation " + operation.getPath(), ex);
        }
    }

    private void verifyAndDeleteToken(Context context, EPerson eperson, String token, Operation operation) {
        try {
            EPerson ePersonFromToken = this.accountService.getEPerson(context, token);
            if (ePersonFromToken == null) {
                throw new AccessDeniedException("The token in the parameter: " + token + " couldn't be associated with an EPerson");
            }
            if (!ePersonFromToken.getID().equals(eperson.getID())) {
                throw new AccessDeniedException("The token in the parameter belongs to a different EPerson than the uri indicates");
            }
            context.setCurrentUser(ePersonFromToken);
            this.accountService.deleteToken(context, token);
        }
        catch (SQLException | AuthorizeException e) {
            log.error("Failed to verify or delete the token for an EPerson patch", e);
        }
    }

    private void verifyCurrentPassword(Context context, EPerson eperson, PasswordVO passwordVO) {
        String currentPassword = passwordVO.getCurrentPassword().orElseThrow(() -> new WrongCurrentPasswordException("No current password provided"));
        boolean canChangePassword = this.authenticationService.canChangePassword(context, eperson, currentPassword);
        if (!canChangePassword) {
            throw new WrongCurrentPasswordException("The provided password is wrong");
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof EPerson && operation.getOp().trim().equalsIgnoreCase("add") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PASSWORD_CHANGE);
    }

    public static class PasswordVO {
        @JsonProperty(value="new_password")
        private String newPassword;
        @JsonProperty(value="current_password")
        private String currentPassword;

        public Optional<String> getNewPassword() {
            return Optional.ofNullable(this.newPassword);
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        public Optional<String> getCurrentPassword() {
            return Optional.ofNullable(this.currentPassword);
        }

        public void setCurrentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
        }
    }
}

