/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dspace.contentreport.QueryOperator;

public class FilteredItemsQueryPredicate {
    private String field;
    private QueryOperator operator;
    private String value;

    public static FilteredItemsQueryPredicate of(String field, QueryOperator operator, String value) {
        FilteredItemsQueryPredicate predicate = new FilteredItemsQueryPredicate();
        predicate.field = field;
        predicate.operator = operator;
        predicate.value = value;
        return predicate;
    }

    public static FilteredItemsQueryPredicate of(String value) {
        String[] tokens = value.split("\\:");
        String field = tokens.length > 0 ? tokens[0].trim() : "";
        QueryOperator operator = tokens.length > 1 ? QueryOperator.get((String)tokens[1].trim()) : null;
        String object = tokens.length > 2 ? StringUtils.trimToEmpty((String)tokens[2]) : "";
        return FilteredItemsQueryPredicate.of(field, operator, object);
    }

    public String getField() {
        return this.field;
    }

    public QueryOperator getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        String op = Optional.ofNullable(this.operator).map(QueryOperator::getCode).orElse("");
        return this.field + ":" + op + ":" + this.value;
    }
}

