/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.health;

import org.apache.commons.lang3.StringUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.web.client.RestTemplate;

public class SEOHealthIndicator
extends AbstractHealthIndicator {
    ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private final RestTemplate restTemplate = new RestTemplate();

    protected void doHealthCheck(Health.Builder builder) {
        String baseUrl = this.configurationService.getProperty("dspace.ui.url");
        boolean sitemapOk = this.checkUrl(baseUrl + "/sitemap_index.xml") || this.checkUrl(baseUrl + "/sitemap_index.html");
        RobotsTxtStatus robotsTxtStatus = this.checkRobotsTxt(baseUrl + "/robots.txt");
        boolean ssrOk = this.checkSSR(baseUrl);
        if (sitemapOk && robotsTxtStatus == RobotsTxtStatus.VALID && ssrOk) {
            builder.up().withDetail("sitemap", (Object)"OK").withDetail("robots.txt", (Object)"OK").withDetail("ssr", (Object)"OK");
        } else {
            builder.down();
            builder.withDetail("sitemap", (Object)(sitemapOk ? "OK" : "Sitemaps are missing or inaccessible. Please see the DSpace Documentation on Search Engine Optimization for how to enable Sitemaps."));
            if (robotsTxtStatus == RobotsTxtStatus.MISSING) {
                builder.withDetail("robots.txt", (Object)"Missing or inaccessible. Please see the DSpace Documentation on Search Engine Optimization for how to create a robots.txt.");
            } else if (robotsTxtStatus == RobotsTxtStatus.INVALID) {
                builder.withDetail("robots.txt", (Object)"Invalid because it contains localhost URLs. This is often a sign that a proxy is failing to pass X-Forwarded headers to DSpace. Please see the DSpace Documentation on Search Engine Optimization for how to pass X-Forwarded headers.");
            } else {
                builder.withDetail("robots.txt", (Object)"OK");
            }
            builder.withDetail("ssr", (Object)(ssrOk ? "OK" : "Server-side rendering (SSR) appears to be disabled.  Most search engines require enabling SSR for proper indexing. Please see the DSpace Documentation on Search Engine Optimization for more details."));
        }
    }

    private boolean checkUrl(String url) {
        try {
            this.restTemplate.getForEntity(url, String.class, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private RobotsTxtStatus checkRobotsTxt(String url) {
        try {
            String content = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
            if (StringUtils.isBlank((CharSequence)content)) {
                return RobotsTxtStatus.MISSING;
            }
            if (content.contains("localhost")) {
                return RobotsTxtStatus.INVALID;
            }
            return RobotsTxtStatus.VALID;
        }
        catch (Exception e) {
            return RobotsTxtStatus.MISSING;
        }
    }

    private boolean checkSSR(String url) {
        try {
            String content = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
            return content != null && !content.contains("<ds-app></ds-app>");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static enum RobotsTxtStatus {
        VALID,
        MISSING,
        INVALID;

    }
}

