/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.hdlresolver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.handle.hdlresolver.HdlResolverDTO;
import org.dspace.handle.hdlresolver.HdlResolverService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(value={"handle.remote-resolver.enabled"})
@RequestMapping(path={"/{hdlService:hdlresolver|resolve|listhandles|listprefixes}/"})
public class HdlResolverRestController {
    static final String HDL_RESOLVER = "/hdlresolver/";
    static final String RESOLVE = "/resolve/";
    static final String LISTHANDLES = "/listhandles/";
    static final String LISTPREFIXES = "/listprefixes/";
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private HdlResolverService hdlResolverService;
    @Autowired
    private ObjectMapper mapper;

    @GetMapping(value={"**"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> handleController(HttpServletRequest request, @PathVariable String hdlService) {
        if (HDL_RESOLVER.contains(hdlService) || RESOLVE.contains(hdlService)) {
            return this.resolveHandle(request, hdlService);
        }
        if (LISTHANDLES.contains(hdlService)) {
            return this.listHandles(request, Optional.ofNullable(request.getRequestURI().split(LISTHANDLES)).filter(split -> ((String[])split).length > 1).map(split -> split[1]).orElse(null));
        }
        if (LISTPREFIXES.contains(hdlService)) {
            return this.listPrefixes(request);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<String> resolveHandle(HttpServletRequest request, String hdlService) {
        HdlResolverDTO handleResolver = this.hdlResolverService.resolveBy(request.getRequestURI(), MessageFormat.format("{0}/{1}/", request.getContextPath(), hdlService));
        if (!handleResolver.isValid()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)this.resolveToURL(request, handleResolver), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<String> listPrefixes(HttpServletRequest request) {
        return new ResponseEntity((Object)this.mapAsJson(this.hdlResolverService.listPrefixes()), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<String> listHandles(HttpServletRequest request, @PathVariable String prefix) {
        if (!this.hdlResolverService.isListhandlesEnabled()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (StringUtils.isBlank((String)prefix)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)this.mapAsJson(this.hdlResolverService.listHandles(ContextUtil.obtainContext(request), prefix)), (HttpStatusCode)HttpStatus.OK);
    }

    private String resolveToURL(HttpServletRequest request, HdlResolverDTO handleResolver) {
        return this.mapAsJson(this.hdlResolverService.resolveToURL(ContextUtil.obtainContext(request), handleResolver));
    }

    protected String mapAsJson(String resolvedUrl) {
        String json = "null";
        if (StringUtils.isNotEmpty((String)resolvedUrl)) {
            json = this.mapAsJson(List.of(resolvedUrl));
        }
        return json;
    }

    protected String mapAsJson(List<String> jsonList) {
        String json = "null";
        if (jsonList != null && !jsonList.isEmpty()) {
            try {
                json = this.mapper.writeValueAsString(jsonList);
            }
            catch (JsonProcessingException e) {
                log.error("Error during conversion of response!", (Throwable)e);
            }
        }
        return json;
    }
}

