/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="reinstateItem", description="It can be used by administrators (or community/collection delegate) to reinstate an item that was previously withdrawn")
public class ReinstateFeature
implements AuthorizationFeature {
    public static final String NAME = "reinstateItem";
    @Autowired
    private Utils utils;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (!(object instanceof ItemRest)) {
            return false;
        }
        Item item = (Item)this.utils.getDSpaceAPIObjectFromRest(context, object);
        if (!item.isWithdrawn()) {
            return false;
        }
        try {
            AuthorizeUtil.authorizeReinstateItem((Context)context, (Item)item);
        }
        catch (AuthorizeException e) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }
}

