/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManagePolicies", description="It can be used to verify if the resourcepolicies of the specified objects can be managed")
public class PolicyFeature
implements AuthorizationFeature {
    public static final String NAME = "canManagePolicies";
    @Autowired
    AuthorizeService authService;
    @Autowired
    private Utils utils;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object != null) {
            try {
                if (object instanceof SiteRest) {
                    return this.authService.isAdmin(context);
                }
                if (object instanceof CommunityRest) {
                    AuthorizeUtil.authorizeManageCommunityPolicy((Context)context, (Community)((Community)this.utils.getDSpaceAPIObjectFromRest(context, object)));
                    return true;
                }
                if (object instanceof CollectionRest) {
                    AuthorizeUtil.authorizeManageCollectionPolicy((Context)context, (Collection)((Collection)this.utils.getDSpaceAPIObjectFromRest(context, object)));
                    return true;
                }
                if (object instanceof ItemRest) {
                    AuthorizeUtil.authorizeManageItemPolicy((Context)context, (Item)((Item)this.utils.getDSpaceAPIObjectFromRest(context, object)));
                    return true;
                }
                if (object instanceof BundleRest) {
                    AuthorizeUtil.authorizeManageBundlePolicy((Context)context, (Bundle)((Bundle)this.utils.getDSpaceAPIObjectFromRest(context, object)));
                    return true;
                }
                if (object instanceof BitstreamRest) {
                    AuthorizeUtil.authorizeManageBitstreamPolicy((Context)context, (Bitstream)((Bitstream)this.utils.getDSpaceAPIObjectFromRest(context, object)));
                    return true;
                }
            }
            catch (AuthorizeException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.site", "core.community", "core.collection", "core.item", "core.bundle", "core.bitstream"};
    }
}

