/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.dspace.app.rest.model.WorkflowActionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.workflowsteps.workflowactions")
public class WorkflowStepActionsLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    protected XmlWorkflowFactory xmlWorkflowFactory;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<WorkflowActionRest> getActions(@Nullable HttpServletRequest request, String workflowStepName, @Nullable Pageable optionalPageable, Projection projection) {
        List actions = this.xmlWorkflowFactory.getStepByName(workflowStepName).getActions();
        Pageable pageable = optionalPageable != null ? optionalPageable : PageRequest.of((int)0, (int)20);
        return this.converter.toRestPage(actions, pageable, projection);
    }
}

