/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.disseminate.service.CitationDocumentService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.utils.DSpace;
import org.springframework.core.io.AbstractResource;
import org.springframework.util.DigestUtils;

public class BitstreamResource
extends AbstractResource {
    static final Logger LOG = LogManager.getLogger(BitstreamResource.class);
    protected final String name;
    protected final UUID uuid;
    protected final UUID currentUserUUID;
    protected final boolean shouldGenerateCoverPage;
    protected final Set<UUID> currentSpecialGroups;
    protected final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected final CitationDocumentService citationDocumentService = (CitationDocumentService)new DSpace().getServiceManager().getServicesByType(CitationDocumentService.class).get(0);
    protected BitstreamDocument document;

    public BitstreamResource(String name, UUID uuid, UUID currentUserUUID, Set<UUID> currentSpecialGroups, boolean shouldGenerateCoverPage) {
        this.name = name;
        this.uuid = uuid;
        this.currentUserUUID = currentUserUUID;
        this.currentSpecialGroups = currentSpecialGroups;
        this.shouldGenerateCoverPage = shouldGenerateCoverPage;
    }

    byte[] getCoverpageByteArray(Context context, Bitstream bitstream) throws IOException, SQLException, AuthorizeException {
        try {
            Pair citedDocument = this.citationDocumentService.makeCitedDocument(context, bitstream);
            return (byte[])citedDocument.getLeft();
        }
        catch (Exception e) {
            LOG.warn("Could not generate cover page. Will fallback to original document", (Throwable)e);
            return IOUtils.toByteArray((InputStream)this.bitstreamService.retrieve(context, bitstream));
        }
    }

    public String getDescription() {
        return "bitstream [" + this.uuid + "]";
    }

    public InputStream getInputStream() throws IOException {
        this.fetchDocument();
        return this.document.inputStream();
    }

    public String getFilename() {
        return this.name;
    }

    public long contentLength() throws IOException {
        this.fetchDocument();
        return this.document.length();
    }

    public String getChecksum() {
        this.fetchDocument();
        return this.document.etag();
    }

    void fetchDocument() {
        if (this.document != null) {
            return;
        }
        try (Context context = this.initializeContext();){
            Bitstream bitstream = this.bitstreamService.find(context, this.uuid);
            if (this.shouldGenerateCoverPage) {
                byte[] coverPage = this.getCoverpageByteArray(context, bitstream);
                this.document = new BitstreamDocument(this.etag(bitstream), coverPage.length, new ByteArrayInputStream(coverPage));
            } else {
                this.document = new BitstreamDocument(bitstream.getChecksum(), bitstream.getSizeBytes(), this.bitstreamService.retrieve(context, bitstream));
            }
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
        LOG.debug("fetched document {} {}", (Object)this.shouldGenerateCoverPage, (Object)this.document);
    }

    String etag(Bitstream bitstream) {
        String content = "coverpage:" + bitstream.getChecksum();
        StringBuilder builder = new StringBuilder(37);
        DigestUtils.appendMd5DigestAsHex((byte[])content.getBytes(), (StringBuilder)builder);
        return builder.toString();
    }

    Context initializeContext() throws SQLException {
        Context context = new Context();
        EPerson currentUser = (EPerson)this.ePersonService.find(context, this.currentUserUUID);
        context.setCurrentUser(currentUser);
        this.currentSpecialGroups.forEach(arg_0 -> ((Context)context).setSpecialGroup(arg_0));
        return context;
    }

    record BitstreamDocument(String etag, long length, InputStream inputStream) {
    }
}

