/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.dspace.app.rest.signposting.model.Linkset;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelation;
import org.dspace.app.rest.signposting.model.LinksetRelationType;

public class LinksetMapper {
    private LinksetMapper() {
    }

    public static Linkset map(List<LinksetNode> linksetNodes) {
        Linkset linkset = new Linkset();
        linkset.setLinkset(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.LINKSET));
        linkset.setAuthor(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.AUTHOR));
        linkset.setItem(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.ITEM));
        linkset.setType(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.TYPE));
        linkset.setCollection(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.COLLECTION));
        linkset.setLicense(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.LICENSE));
        linkset.setCiteAs(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.CITE_AS));
        linkset.setDescribes(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.DESCRIBES));
        linkset.setDescribedby(LinksetMapper.getLinksetRelationsByType(linksetNodes, LinksetRelationType.DESCRIBED_BY));
        if (!linksetNodes.isEmpty()) {
            linkset.setAnchor(linksetNodes.get(0).getAnchor());
        }
        return linkset;
    }

    private static List<LinksetRelation> getLinksetRelationsByType(List<LinksetNode> linkset, LinksetRelationType type) {
        return linkset.stream().filter(linksetNode -> type.equals((Object)linksetNode.getRelation())).map(linksetNode -> new LinksetRelation(linksetNode.getLink(), linksetNode.getType())).collect(Collectors.toList());
    }
}

