/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.login.PostLoggedInAction;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class EPersonRestAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LogManager.getLogger();
    public static final String MANAGE_ACCESS_GROUP = "MANAGE_ACCESS_GROUP";
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private HttpServletRequest request;
    @Autowired(required=false)
    private List<PostLoggedInAction> postLoggedInActions;

    @PostConstruct
    public void postConstruct() {
        if (this.postLoggedInActions == null) {
            this.postLoggedInActions = Collections.emptyList();
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Context context = ContextUtil.obtainContext(this.request);
        if (context != null && context.getCurrentUser() != null) {
            log.debug("Request to refresh auth token");
            return this.authenticateRefreshTokenRequest(context);
        }
        log.debug("Request to authenticate new login");
        return this.authenticateNewLogin(authentication);
    }

    private Authentication authenticateRefreshTokenRequest(Context context) {
        this.authenticationService.updateLastActiveDate(context);
        return this.createAuthentication(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authentication authenticateNewLogin(Authentication authentication) {
        Authentication output;
        block14: {
            Context newContext = null;
            output = null;
            if (authentication != null) {
                try {
                    newContext = new Context();
                    String name = authentication.getName();
                    String password = Objects.toString(authentication.getCredentials(), null);
                    int implicitStatus = this.authenticationService.authenticateImplicit(newContext, null, null, null, this.request);
                    if (implicitStatus == 1) {
                        log.info(LogHelper.getHeader((Context)newContext, (String)"login", (String)"type=implicit"));
                        output = this.createAuthentication(newContext);
                        break block14;
                    }
                    int authenticateResult = this.authenticationService.authenticate(newContext, name, password, null, this.request);
                    if (1 == authenticateResult) {
                        log.info(LogHelper.getHeader((Context)newContext, (String)"login", (String)"type=explicit"));
                        output = this.createAuthentication(newContext);
                        for (PostLoggedInAction action : this.postLoggedInActions) {
                            try {
                                action.loggedIn(newContext);
                            }
                            catch (Exception ex) {
                                log.error("An error occurs performing post logged in action", (Throwable)ex);
                            }
                        }
                        break block14;
                    }
                    log.info(LogHelper.getHeader((Context)newContext, (String)"failed_login", (String)"email={}, result={}"), (Object)name, (Object)authenticateResult);
                    throw new BadCredentialsException("Login failed");
                }
                finally {
                    if (newContext != null && newContext.isValid()) {
                        try {
                            newContext.complete();
                        }
                        catch (SQLException e) {
                            log.error("{} occurred while trying to close", (Object)e.getMessage(), (Object)e);
                        }
                    }
                }
            }
        }
        return output;
    }

    private Authentication createAuthentication(Context context) {
        EPerson ePerson = context.getCurrentUser();
        if (ePerson != null && StringUtils.isNotBlank((CharSequence)ePerson.getEmail())) {
            this.requestService.setCurrentUserId(ePerson.getID());
            return new DSpaceAuthentication(ePerson, this.getGrantedAuthorities(context));
        }
        log.info(LogHelper.getHeader((Context)context, (String)"failed_login", (String)"No eperson with a non-blank e-mail address found"));
        throw new BadCredentialsException("Login failed");
    }

    public List<GrantedAuthority> getGrantedAuthorities(Context context) {
        LinkedList<GrantedAuthority> authorities = new LinkedList<GrantedAuthority>();
        EPerson eperson = context.getCurrentUser();
        if (eperson != null) {
            boolean isAdmin = false;
            try {
                isAdmin = this.authorizeService.isAdmin(context, eperson);
            }
            catch (SQLException e) {
                log.error("SQL error while checking for admin rights", (Throwable)e);
            }
            if (isAdmin) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ADMIN"));
            } else if (this.authorizeService.isAccountManager(context)) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(MANAGE_ACCESS_GROUP));
            }
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority("AUTHENTICATED"));
        }
        return authorities;
    }

    public boolean supports(Class<?> authentication) {
        return DSpaceAuthentication.class.isAssignableFrom(authentication);
    }
}

