/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.DSpaceObjectUtils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class BitstreamMetadataReadPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private RequestService requestService;
    @Autowired
    private DSpaceObjectUtils dspaceObjectUtil;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    protected BitstreamService bitstreamService;
    private static final String METADATA_READ_PERMISSION = "METADATA_READ";

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        if (permission.toString().equalsIgnoreCase(METADATA_READ_PERMISSION) && targetId != null) {
            Request request = this.requestService.getCurrentRequest();
            Context context = ContextUtil.obtainContext(request.getHttpServletRequest());
            try {
                UUID dsoUuid = UUID.fromString(targetId.toString());
                DSpaceObject dso = this.dspaceObjectUtil.findDSpaceObject(context, dsoUuid);
                if (dso instanceof Bitstream) {
                    return this.metadataReadPermissionOnBitstream(context, (Bitstream)dso);
                }
            }
            catch (SQLException e) {
                log.error(e::getMessage, (Throwable)e);
            }
        }
        return false;
    }

    public boolean metadataReadPermissionOnBitstream(Context context, Bitstream bitstream) throws SQLException {
        if (this.authorizeService.isAdmin(context, (DSpaceObject)bitstream)) {
            return true;
        }
        if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)bitstream, 0)) {
            return true;
        }
        DSpaceObject bitstreamParentObject = this.bitstreamService.getParentObject(context, (DSpaceObject)bitstream);
        if (bitstreamParentObject instanceof Item && !bitstream.getBundles().isEmpty()) {
            Bundle firstBundle = (Bundle)bitstream.getBundles().get(0);
            if (this.authorizeService.authorizeActionBoolean(context, bitstreamParentObject, 0) && this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)firstBundle, 0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission restPermission) {
        return false;
    }
}

